/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageDaoImpl;
import org.apache.ode.daohib.bpel.PartnerLinkDAOImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeDaoImpl
extends HibernateDao
implements MessageExchangeDAO {
    private static final Log __log = LogFactory.getLog(MessageExchangeDaoImpl.class);
    private HMessageExchange _hself;
    private ProcessDAO _externalProcess;
    private ProcessInstanceDAO _externalInstance;

    public MessageExchangeDaoImpl(SessionManager sessionManager, HMessageExchange hMessageExchange) {
        super(sessionManager, hMessageExchange);
        this.entering("MessageExchangeDaoImpl.MessageExchangeDaoImpl");
        this._hself = hMessageExchange;
    }

    public String getMessageExchangeId() {
        return this._hself.getId().toString();
    }

    public MessageDAO getResponse() {
        this.entering("MessageExchangeDaoImpl.getResponse");
        return this._hself.getResponse() == null ? null : new MessageDaoImpl(this._sm, this._hself.getResponse());
    }

    public Date getCreateTime() {
        return this._hself.getInsertTime();
    }

    public MessageDAO getRequest() {
        this.entering("MessageExchangeDaoImpl.getRequest");
        return this._hself.getRequest() == null ? null : new MessageDaoImpl(this._sm, this._hself.getRequest());
    }

    public String getOperation() {
        return this._hself.getOperationName();
    }

    public QName getPortType() {
        return this._hself.getPortType() == null ? null : QName.valueOf(this._hself.getPortType());
    }

    public void setPortType(QName qName) {
        this.entering("MessageExchangeDaoImpl.setPortType");
        this._hself.setPortType(qName == null ? null : qName.toString());
        this.update();
    }

    public void setStatus(String string) {
        this.entering("MessageExchangeDaoImpl.setStatus");
        this._hself.setState(string);
        this.update();
    }

    public String getStatus() {
        return this._hself.getState();
    }

    public MessageDAO createMessage(QName qName) {
        this.entering("MessageExchangeDaoImpl.createMessage");
        HMessage hMessage = new HMessage();
        hMessage.setType(qName == null ? null : qName.toString());
        hMessage.setCreated(new Date());
        hMessage.setMessageExchange(this._hself);
        this.getSession().save((Object)hMessage);
        return new MessageDaoImpl(this._sm, hMessage);
    }

    public void setRequest(MessageDAO messageDAO) {
        this.entering("MessageExchangeDaoImpl.setRequest");
        this._hself.setRequest(messageDAO == null ? null : (HMessage)((MessageDaoImpl)messageDAO).getHibernateObj());
        this.update();
    }

    public void setResponse(MessageDAO messageDAO) {
        this.entering("MessageExchangeDaoImpl.setResponse");
        this._hself.setResponse(messageDAO == null ? null : (HMessage)((MessageDaoImpl)messageDAO).getHibernateObj());
        this.update();
    }

    public int getPartnerLinkModelId() {
        return this._hself.getPartnerLinkModelId();
    }

    public void setPartnerLinkModelId(int n) {
        this.entering("MessageExchangeDaoImpl.setPartnerLinkModelId");
        this._hself.setPartnerLinkModelId(n);
        this.update();
    }

    public String getCorrelationId() {
        return this._hself.getClientKey();
    }

    public void setCorrelationId(String string) {
        this.entering("MessageExchangeDaoImpl.setCorrelationId");
        this._hself.setClientKey(string);
        this.update();
    }

    public void setPattern(String string) {
        this.entering("MessageExchangeDaoImpl.setPattern");
        this._hself.setPattern(string);
        this.update();
    }

    public void setOperation(String string) {
        this.entering("MessageExchangeDaoImpl.setOperation");
        this._hself.setOperationName(string);
        this.update();
    }

    public void setEPR(Element element) {
        this.entering("MessageExchangeDaoImpl.setEPR");
        if (element == null) {
            this._hself.setEndpoint(null);
        } else {
            HLargeData hLargeData = new HLargeData(DOMUtils.domToString((Node)element));
            this.getSession().save((Object)hLargeData);
            this._hself.setEndpoint(hLargeData);
        }
        this.getSession().saveOrUpdate((Object)this._hself);
    }

    public Element getEPR() {
        this.entering("MessageExchangeDaoImpl.getEPR");
        HLargeData hLargeData = this._hself.getEndpoint();
        if (hLargeData == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((String)hLargeData.getText());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setCallbackEPR(Element element) {
        this.entering("MessageExchangeDaoImpl.setCallbackEPR");
        if (element == null) {
            this._hself.setCallbackEndpoint(null);
        } else {
            HLargeData hLargeData = new HLargeData(DOMUtils.domToString((Node)element));
            this.getSession().save((Object)hLargeData);
            this._hself.setCallbackEndpoint(hLargeData);
        }
        this.getSession().saveOrUpdate((Object)this._hself);
    }

    public Element getCallbackEPR() {
        this.entering("MessageExchangeDaoImpl.getCallbackEPR");
        HLargeData hLargeData = this._hself.getCallbackEndpoint();
        if (hLargeData == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((String)hLargeData.getText());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getPattern() {
        return this._hself.getPattern();
    }

    public String getChannel() {
        return this._hself.getChannelName();
    }

    public void setChannel(String string) {
        this.entering("MessageExchangeDaoImpl.setChannel");
        this._hself.setChannelName(string);
        this.update();
    }

    public boolean getPropagateTransactionFlag() {
        return false;
    }

    public QName getFault() {
        return this._hself.getFault() == null ? null : QName.valueOf(this._hself.getFault());
    }

    public void setFault(QName qName) {
        this.entering("MessageExchangeDaoImpl.setFault");
        this._hself.setFault(qName == null ? null : qName.toString());
        this.update();
    }

    public String getFaultExplanation() {
        return this._hself.getFaultExplanation();
    }

    public void setFaultExplanation(String string) {
        this.entering("MessageExchangeDaoImpl.setFaultExplanation");
        this._hself.setFaultExplanation(string);
        this.update();
    }

    public void setCorrelationStatus(String string) {
        this.entering("MessageExchangeDaoImpl.setCorrelationStatus");
        this._hself.setCorrelationStatus(string);
        this.update();
    }

    public String getCorrelationStatus() {
        return this._hself.getCorrelationStatus();
    }

    public ProcessDAO getProcess() {
        this.entering("MessageExchangeDaoImpl.getProcess");
        if (this._externalProcess != null) {
            return this._externalProcess;
        }
        return this._hself.getProcess() == null ? null : new ProcessDaoImpl(this._sm, this._hself.getProcess());
    }

    public void setProcess(ProcessDAO processDAO) {
        this.entering("MessageExchangeDaoImpl.setProcess");
        if (processDAO == null || processDAO instanceof ProcessDaoImpl) {
            this._hself.setProcess(processDAO == null ? null : (HProcess)((ProcessDaoImpl)processDAO).getHibernateObj());
            this.update();
        } else {
            this._externalProcess = processDAO;
        }
    }

    public void setInstance(ProcessInstanceDAO processInstanceDAO) {
        this.entering("MessageExchangeDaoImpl.setInstance");
        if (processInstanceDAO == null || processInstanceDAO instanceof ProcessInstanceDaoImpl) {
            this._hself.setInstance(processInstanceDAO == null ? null : (HProcessInstance)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
            this.update();
        } else {
            this._externalInstance = processInstanceDAO;
        }
    }

    public ProcessInstanceDAO getInstance() {
        this.entering("MessageExchangeDaoImpl.getInstance");
        if (this._externalInstance != null) {
            return this._externalInstance;
        }
        return this._hself.getInstance() == null ? null : new ProcessInstanceDaoImpl(this._sm, this._hself.getInstance());
    }

    public char getDirection() {
        return this._hself.getDirection();
    }

    public QName getCallee() {
        String string = this._hself.getCallee();
        return string == null ? null : QName.valueOf(string);
    }

    public void setCallee(QName qName) {
        this.entering("MessageExchangeDaoImpl.setCallee");
        this._hself.setCallee(qName == null ? null : qName.toString());
        this.update();
    }

    public String getProperty(String string) {
        this.entering("MessageExchangeDaoImpl.getProperty");
        return this._hself.getProperties().get(string);
    }

    public void setProperty(String string, String string2) {
        this.entering("MessageExchangeDaoImpl.setProperty");
        this._hself.getProperties().put(string, string2);
        this.update();
    }

    public void setPartnerLink(PartnerLinkDAO partnerLinkDAO) {
        this.entering("MessageExchangeDaoImpl.setPartnerLink");
        this._hself.setPartnerLink(((PartnerLinkDAOImpl)partnerLinkDAO)._self);
        this.update();
    }

    public PartnerLinkDAO getPartnerLink() {
        this.entering("MessageExchangeDaoImpl.getPartnerLink");
        return new PartnerLinkDAOImpl(this._sm, this._hself.getPartnerLink());
    }

    public Set<String> getPropertyNames() {
        this.entering("MessageExchangeDaoImpl.getPropertyNames");
        return Collections.unmodifiableSet(this._hself.getProperties().keySet());
    }

    public String getPipedMessageExchangeId() {
        return this._hself.getPipedMessageExchangeId();
    }

    public void setPipedMessageExchangeId(String string) {
        this.entering("MessageExchangeDaoImpl.setPipedMessageExchangeId");
        this._hself.setPipedMessageExchangeId(string);
    }

    public int getSubscriberCount() {
        return this._hself.getSubscriberCount();
    }

    public void setSubscriberCount(int n) {
        this._hself.setSubscriberCount(n);
    }

    public void release(boolean bl) {
        if (bl) {
            this.deleteMessages();
        }
    }

    public void releasePremieMessages() {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MESSAGE_LDATA_IDS_BY_MEX_1").setParameter("mex", (Object)this._hself).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MESSAGE_LDATA_IDS_BY_MEX_2").setParameter("mex", (Object)this._hself).list());
        this.deleteByIds(HCorrelatorMessage.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_MEX").setParameter("mex", (Object)this._hself).list());
    }

    public void incrementSubscriberCount() {
        this._hself.incrementSubscriberCount();
    }

    public void deleteMessages() {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MESSAGE_LDATA_IDS_BY_MEX_1").setParameter("mex", (Object)this._hself).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MESSAGE_LDATA_IDS_BY_MEX_2").setParameter("mex", (Object)this._hself).list());
        this.deleteByIds(HCorrelatorMessage.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_MEX").setParameter("mex", (Object)this._hself).list());
        this.getSession().delete((Object)this._hself);
    }
}

