/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.DeferredProcessInstanceCleanable;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.apache.ode.daohib.bpel.CorrelatorDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HMessageExchangeProperty;
import org.apache.ode.daohib.bpel.hobj.HObject;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDaoImpl
extends HibernateDao
implements ProcessDAO,
DeferredProcessInstanceCleanable {
    private static final Log __log = LogFactory.getLog(ProcessDaoImpl.class);
    private static final String QRY_CORRELATOR = "where this.correlatorId = ?";
    private HProcess _process;

    public ProcessDaoImpl(SessionManager sessionManager, HProcess hProcess) {
        super(sessionManager, hProcess);
        this.entering("ProcessDaoImpl.ProcessDaoImpl");
        this._process = hProcess;
    }

    public QName getProcessId() {
        return QName.valueOf(this._process.getProcessId());
    }

    public ProcessInstanceDAO getInstance(Long l) {
        this.entering("ProcessDaoImpl.getInstance");
        ProcessInstanceDAO processInstanceDAO = BpelDAOConnectionImpl._getInstance(this._sm, this.getSession(), l);
        if (processInstanceDAO == null || !processInstanceDAO.getProcess().getProcessId().equals(this.getProcessId())) {
            return null;
        }
        return processInstanceDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorrelatorDAO getCorrelator(String string) {
        this.entering("ProcessDaoImpl.getCorrelator");
        Query query = this.getSession().createFilter(this._process.getCorrelators(), QRY_CORRELATOR);
        Iterator iterator = query.setString(0, string).iterate();
        if (!iterator.hasNext()) {
            String string2 = "no such correlator: corrId = " + string;
            throw new IllegalArgumentException(string2);
        }
        try {
            CorrelatorDaoImpl correlatorDaoImpl = new CorrelatorDaoImpl(this._sm, (HCorrelator)iterator.next());
            return correlatorDaoImpl;
        }
        finally {
            Hibernate.close((Iterator)iterator);
        }
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        this.entering("ProcessDaoImpl.removeRoutes");
        for (HCorrelator hCorrelator : this._process.getCorrelators()) {
            new CorrelatorDaoImpl(this._sm, hCorrelator).removeRoutes(string, processInstanceDAO);
        }
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO correlatorDAO) {
        this.entering("ProcessDaoImpl.createInstance");
        HProcessInstance hProcessInstance = new HProcessInstance();
        hProcessInstance.setInstantiatingCorrelator((HCorrelator)((CorrelatorDaoImpl)correlatorDAO).getHibernateObj());
        hProcessInstance.setProcess(this._process);
        hProcessInstance.setCreated(new Date());
        this.getSession().save((Object)hProcessInstance);
        return new ProcessInstanceDaoImpl(this._sm, hProcessInstance);
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey correlationKey) {
        this.entering("ProcessDaoImpl.findInstance");
        Criteria criteria = this.getSession().createCriteria(HCorrelationSet.class);
        criteria.add((Criterion)Expression.eq((String)"scope.instance.process.id", (Object)this._process.getId()));
        criteria.add((Criterion)Expression.eq((String)"value", (Object)correlationKey.toCanonicalString()));
        criteria.addOrder(Order.desc((String)"scope.instance.created"));
        return criteria.list();
    }

    public void instanceCompleted(ProcessInstanceDAO processInstanceDAO) {
    }

    public void deleteProcessAndRoutes() {
        this.deleteByIds(HCorrelatorSelector.class, this.getSession().getNamedQuery("SELECT_MESSAGE_ROUTE_IDS_BY_PROCESS").setParameter("process", (Object)this._process).list());
        this.deleteByIds(HCorrelator.class, this.getSession().getNamedQuery("SELECT_CORRELATOR_IDS_BY_PROCESS").setParameter("process", (Object)this._process).list());
        this.getSession().delete((Object)this._process);
        this.getSession().flush();
    }

    public int deleteInstances(int n) {
        List list;
        this.entering("ProcessDaoImpl.delete");
        if (n < 1) {
            if (__log.isWarnEnabled()) {
                __log.warn((Object)"A zero or negative value was given for the transaction size of process dao deletion; overriding to '1'. Not using bulk deletion of rows may result in performance degradation.");
            }
            n = 1;
        }
        if (!(list = this.getSession().getNamedQuery("SELECT_INSTANCES_BY_PROCESS").setParameter("process", (Object)this._process).setMaxResults(n).list()).isEmpty()) {
            this.deleteEvents(list);
            this.deleteCorrelations(list);
            this.deleteMessages(list);
            this.deleteVariables(list);
            this.deleteProcessInstances(list);
        }
        return list.size();
    }

    public int deleteInstances(Collection<HProcessInstance> collection, Set<ProcessConf.CLEANUP_CATEGORY> set) {
        this.entering("ProcessDaoImpl.deleteInstances");
        if (!collection.isEmpty()) {
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.EVENTS)) {
                this.deleteEvents(collection);
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS)) {
                this.deleteCorrelations(collection);
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
                this.deleteMessages(collection);
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.VARIABLES)) {
                this.deleteVariables(collection);
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE)) {
                this.deleteProcessInstances(collection);
            }
        }
        return collection.size();
    }

    private void deleteProcessInstances(Collection<HProcessInstance> collection) {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_ACTIVITY_RECOVERY_LDATA_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HActivityRecovery.class, this.getSession().getNamedQuery("SELECT_ACTIVITY_RECOVERY_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_FAULT_LDATA_IDS_BY_INSTANCE_IDS").setParameterList("instanceIds", HObject.toIdArray(collection)).list());
        this.deleteByIds(HFaultData.class, this.getSession().getNamedQuery("SELECT_FAULT_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_JACOB_LDATA_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (HProcessInstance hProcessInstance : collection) {
            arrayList.add(hProcessInstance.getId());
        }
        this.deleteByIds(HProcessInstance.class, arrayList);
    }

    private void deleteVariables(Collection<HProcessInstance> collection) {
        this.deleteByIds(HVariableProperty.class, this.getSession().getNamedQuery("SELECT_VARIABLE_PROPERTY_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_XMLDATA_LDATA_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HXmlData.class, this.getSession().getNamedQuery("SELECT_XMLDATA_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_LDATA_IDS_BY_INSTANCES_1").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_LDATA_IDS_BY_INSTANCES_2").setParameterList("instances", collection).list());
        this.deleteByIds(HPartnerLink.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HScope.class, this.getSession().getNamedQuery("SELECT_SCOPE_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
    }

    private void deleteMessages(Collection<HProcessInstance> collection) {
        this.deleteByIds(HActivityRecovery.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MESSAGE_LDATA_IDS_BY_INSTANCES_1").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MESSAGE_LDATA_IDS_BY_INSTANCES_2").setParameterList("instances", collection).list());
        this.deleteByIds(HMessage.class, this.getSession().getNamedQuery("SELECT_MESSAGE_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HMessageExchangeProperty.class, this.getSession().getNamedQuery("SELECT_MEX_PROPS_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MEX_LDATA_IDS_BY_INSTANCES_1").setParameterList("instances", collection).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_MEX_LDATA_IDS_BY_INSTANCES_2").setParameterList("instances", collection).list());
        this.deleteByIds(HMessageExchange.class, this.getSession().getNamedQuery("SELECT_MEX_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
    }

    private void deleteCorrelations(Collection<HProcessInstance> collection) {
        this.deleteByIds(HCorrelationProperty.class, this.getSession().getNamedQuery("SELECT_CORPROP_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HCorrelationSet.class, this.getSession().getNamedQuery("SELECT_CORSET_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
    }

    private void deleteEvents(Collection<HProcessInstance> collection) {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_EVENT_LDATA_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
        this.deleteByIds(HBpelEvent.class, this.getSession().getNamedQuery("SELECT_EVENT_IDS_BY_INSTANCES").setParameterList("instances", collection).list());
    }

    public QName getType() {
        return new QName(this._process.getTypeNamespace(), this._process.getTypeName());
    }

    public long getVersion() {
        return this._process.getVersion();
    }

    public CorrelatorDAO addCorrelator(String string) {
        this.entering("ProcessDaoImpl.addCorrelator");
        HCorrelator hCorrelator = new HCorrelator();
        hCorrelator.setCorrelatorId(string);
        hCorrelator.setProcess(this._process);
        hCorrelator.setCreated(new Date());
        this.getSession().save((Object)hCorrelator);
        this.getSession().saveOrUpdate((Object)this._process);
        return new CorrelatorDaoImpl(this._sm, hCorrelator);
    }

    public Collection<ProcessInstanceDAO> getActiveInstances() {
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>();
        List list = this.getSession().getNamedQuery("SELECT_INSTANCES_BY_PROCESS_AND_STATES").setParameter("process", (Object)this._process).setParameterList("states", new Object[]{(short)20}).list();
        for (HProcessInstance hProcessInstance : list) {
            arrayList.add(new ProcessInstanceDaoImpl(this._sm, hProcessInstance));
        }
        return arrayList;
    }

    public int getNumInstances() {
        this.entering("ProcessDaoImpl.getNumInstances");
        return this._process.getInstances().size();
    }

    public String getGuid() {
        return this._process.getGuid();
    }
}

