/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.ActivityRecoveryDaoImpl;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.CorrelatorDaoImpl;
import org.apache.ode.daohib.bpel.FaultDAOImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.XmlDataDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HObject;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.QNameUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceDaoImpl
extends HibernateDao
implements ProcessInstanceDAO {
    private static final Log __log = LogFactory.getLog(ProcessInstanceDaoImpl.class);
    private static final String QRY_DELSELECTORS = "delete from " + HCorrelatorSelector.class.getName() + " where instance = ?";
    private static final String QRY_VARIABLES = "from " + HXmlData.class.getName() + " as x where x.name = ? and x.scope.scopeModelId = ? and x.scope.instance.id = ?";
    private static final String QRY_RECOVERIES = "from " + HActivityRecovery.class.getName() + " AS x WHERE x.instance.id = ?";
    private HProcessInstance _instance;
    private ScopeDAO _root;

    public ProcessInstanceDaoImpl(SessionManager sessionManager, HProcessInstance hProcessInstance) {
        super(sessionManager, hProcessInstance);
        this.entering("ProcessInstanceDaoImpl.ProcessInstanceDaoImpl");
        this._instance = hProcessInstance;
    }

    public Date getCreateTime() {
        return this._instance.getCreated();
    }

    public void setFault(FaultDAO faultDAO) {
        this.entering("ProcessInstanceDaoImpl.setFault");
        this._instance.setFault(((FaultDAOImpl)faultDAO)._self);
        this.getSession().update((Object)this._instance);
    }

    public void setFault(QName qName, String string, int n, int n2, Element element) {
        this.entering("ProcessInstanceDaoImpl.setFault");
        if (this._instance.getFault() != null) {
            this.getSession().delete((Object)this._instance.getFault());
        }
        HFaultData hFaultData = new HFaultData();
        hFaultData.setName(QNameUtils.fromQName((QName)qName));
        hFaultData.setExplanation(string);
        hFaultData.setLineNo(n);
        hFaultData.setActivityId(n2);
        if (element != null) {
            HLargeData hLargeData = new HLargeData(DOMUtils.domToString((Node)element));
            hFaultData.setData(hLargeData);
            this.getSession().save((Object)hLargeData);
        }
        this._instance.setFault(hFaultData);
        this.getSession().save((Object)hFaultData);
        this.getSession().update((Object)this._instance);
    }

    public FaultDAO getFault() {
        this.entering("ProcessInstanceDaoImpl.getFault");
        if (this._instance.getFault() == null) {
            return null;
        }
        return new FaultDAOImpl(this._sm, this._instance.getFault());
    }

    public byte[] getExecutionState() {
        this.entering("ProcessInstanceDaoImpl.getExecutionState");
        if (this._instance.getJacobState() == null) {
            return null;
        }
        return this._instance.getJacobState().getBinary();
    }

    public void setExecutionState(byte[] byArray) {
        this.entering("ProcessInstanceDaoImpl.setExecutionState");
        if (this._instance.getJacobState() != null) {
            this.getSession().delete((Object)this._instance.getJacobState());
        }
        if (byArray.length > 0) {
            HLargeData hLargeData = new HLargeData(byArray);
            this._instance.setJacobState(hLargeData);
            this.getSession().save((Object)hLargeData);
        }
        this.getSession().update((Object)this._instance);
    }

    public ProcessDAO getProcess() {
        this.entering("ProcessInstanceDaoImpl.getProcess");
        return new ProcessDaoImpl(this._sm, this._instance.getProcess());
    }

    public ScopeDAO getRootScope() {
        this.entering("ProcessInstanceDaoImpl.getRootScope");
        if (this._root != null) {
            return this._root;
        }
        Query query = this.getSession().createFilter(this._instance.getScopes(), "where this.parentScope is null");
        HScope hScope = (HScope)query.uniqueResult();
        if (hScope == null) {
            return null;
        }
        this._root = new ScopeDaoImpl(this._sm, hScope);
        return this._root;
    }

    public void setState(short s) {
        this.entering("ProcessInstanceDaoImpl.setState");
        this._instance.setPreviousState(this._instance.getState());
        this._instance.setState(s);
        if (s == 60) {
            this.clearSelectors();
        }
        this.getSession().update((Object)this._instance);
    }

    public short getState() {
        return this._instance.getState();
    }

    public short getPreviousState() {
        return this._instance.getPreviousState();
    }

    public ScopeDAO createScope(ScopeDAO scopeDAO, String string, int n) {
        this.entering("ProcessInstanceDaoImpl.createScope");
        HScope hScope = new HScope();
        hScope.setParentScope(scopeDAO != null ? (HScope)((ScopeDaoImpl)scopeDAO).getHibernateObj() : null);
        hScope.setName(string);
        hScope.setScopeModelId(n);
        hScope.setState(ScopeStateEnum.ACTIVE.toString());
        hScope.setInstance(this._instance);
        hScope.setCreated(new Date());
        this.getSession().save((Object)hScope);
        return new ScopeDaoImpl(this._sm, hScope);
    }

    public Long getInstanceId() {
        return this._instance.getId();
    }

    public ScopeDAO getScope(Long l) {
        this.entering("ProcessInstanceDaoImpl.getScope");
        Long l2 = (long)l;
        HScope hScope = (HScope)this.getSession().get(HScope.class, (Serializable)l2);
        return hScope != null ? new ScopeDaoImpl(this._sm, hScope) : null;
    }

    public Collection<ScopeDAO> getScopes(String string) {
        List list;
        Query query;
        this.entering("ProcessInstanceDaoImpl.getScopes");
        if (string != null) {
            query = this._sm.getSession().createFilter(this._instance.getScopes(), "where this.name=?");
            query.setString(0, string);
            list = query.list();
        } else {
            list = this._instance.getScopes();
        }
        query = new ArrayList();
        CollectionsX.transform((Collection)query, list, (UnaryFunction)new UnaryFunction<HScope, ScopeDAO>(){

            public ScopeDAO apply(HScope hScope) {
                return new ScopeDaoImpl(ProcessInstanceDaoImpl.this._sm, hScope);
            }
        });
        return query;
    }

    public Collection<ScopeDAO> getScopes() {
        return this.getScopes(null);
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        this.entering("ProcessInstanceDaoImpl.getInstantiatingCorrelator");
        return new CorrelatorDaoImpl(this._sm, this._instance.getInstantiatingCorrelator());
    }

    public Date getLastActiveTime() {
        return this._instance.getLastActiveTime();
    }

    public void setLastActiveTime(Date date) {
        this.entering("ProcessInstanceDaoImpl.setLastActiveTime");
        this._instance.setLastActiveTime(date);
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        this.entering("ProcessInstanceDaoImpl.getCorrelationSets");
        HashSet<CorrelationSetDAO> hashSet = new HashSet<CorrelationSetDAO>();
        for (HCorrelationSet hCorrelationSet : this._instance.getCorrelationSets()) {
            hashSet.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return hashSet;
    }

    public CorrelationSetDAO getCorrelationSet(String string) {
        this.entering("ProcessInstanceDaoImpl.getCorrelationSet");
        for (HCorrelationSet hCorrelationSet : this._instance.getCorrelationSets()) {
            if (!hCorrelationSet.getName().equals(string)) continue;
            return new CorrelationSetDaoImpl(this._sm, hCorrelationSet);
        }
        return null;
    }

    public XmlDataDAO[] getVariables(String string, int n) {
        this.entering("ProcessInstanceDaoImpl.getVariables");
        ArrayList<XmlDataDaoImpl> arrayList = new ArrayList<XmlDataDaoImpl>();
        Query query = this.getSession().createQuery(QRY_VARIABLES);
        query.setString(0, string);
        query.setInteger(1, n);
        query.setLong(2, this._instance.getId().longValue());
        Iterator iterator = query.iterate();
        while (iterator.hasNext()) {
            arrayList.add(new XmlDataDaoImpl(this._sm, (HXmlData)iterator.next()));
        }
        Hibernate.close((Iterator)iterator);
        return arrayList.toArray(new XmlDataDAO[arrayList.size()]);
    }

    public void finishCompletion() {
        this.entering("ProcessInstanceDaoImpl.finishCompletion");
        assert (ProcessState.isFinished((short)this.getState()));
        this.getProcess().instanceCompleted((ProcessInstanceDAO)this);
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> set) {
        this.entering("ProcessInstanceDaoImpl.delete");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Cleaning up instance data with categories = " + set));
        }
        if (this._instance.getJacobState() != null) {
            this.getSession().delete((Object)this._instance.getJacobState());
            this._instance.setJacobState(null);
        }
        HProcessInstance[] hProcessInstanceArray = new HProcessInstance[]{this._instance};
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.EVENTS)) {
            this.deleteEvents(hProcessInstanceArray);
        }
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS)) {
            this.deleteCorrelations(hProcessInstanceArray);
        }
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
            this.deleteMessages(hProcessInstanceArray);
        }
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.VARIABLES)) {
            this.deleteVariables(hProcessInstanceArray);
        }
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE)) {
            this.deleteInstances(hProcessInstanceArray);
        }
        this.getSession().flush();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Instance data cleaned up and flushed.");
        }
    }

    private void deleteInstances(HProcessInstance[] hProcessInstanceArray) {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_FAULT_LDATA_IDS_BY_INSTANCE_IDS").setParameterList("instanceIds", HObject.toIdArray((HObject[])hProcessInstanceArray)).list());
        this.deleteByIds(HFaultData.class, this.getSession().getNamedQuery("SELECT_FAULT_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.getSession().delete((Object)this._instance);
    }

    private void deleteVariables(HProcessInstance[] hProcessInstanceArray) {
        this.deleteByIds(HCorrelationProperty.class, this.getSession().getNamedQuery("SELECT_CORPROP_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HCorrelationSet.class, this.getSession().getNamedQuery("SELECT_CORSET_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HVariableProperty.class, this.getSession().getNamedQuery("SELECT_VARIABLE_PROPERTY_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_XMLDATA_LDATA_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HXmlData.class, this.getSession().getNamedQuery("SELECT_XMLDATA_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_LDATA_IDS_BY_INSTANCES_1").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_LDATA_IDS_BY_INSTANCES_2").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HPartnerLink.class, this.getSession().getNamedQuery("SELECT_PARTNER_LINK_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HScope.class, this.getSession().getNamedQuery("SELECT_SCOPE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
    }

    private void deleteMessages(HProcessInstance[] hProcessInstanceArray) {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_UNMATCHED_MESSAGE_LDATA_IDS_BY_INSTANCES_1").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_UNMATCHED_MESSAGE_LDATA_IDS_BY_INSTANCES_2").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        List list = this.getSession().getNamedQuery("SELECT_UNMATCHED_MEX_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list();
        if (!list.isEmpty()) {
            this.getSession().delete((Object)list);
        }
        this.deleteByIds(HCorrelatorMessage.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HCorrelatorSelector.class, this.getSession().getNamedQuery("SELECT_MESSAGE_ROUTE_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
    }

    private void deleteCorrelations(HProcessInstance[] hProcessInstanceArray) {
        this.deleteByIds(HCorrelationProperty.class, this.getSession().getNamedQuery("SELECT_CORPROP_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HCorrelationSet.class, this.getSession().getNamedQuery("SELECT_CORSET_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
    }

    private void deleteEvents(HProcessInstance[] hProcessInstanceArray) {
        this.deleteByIds(HLargeData.class, this.getSession().getNamedQuery("SELECT_EVENT_LDATA_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
        this.deleteByIds(HBpelEvent.class, this.getSession().getNamedQuery("SELECT_EVENT_IDS_BY_INSTANCES").setParameterList("instances", (Object[])hProcessInstanceArray).list());
    }

    public void insertBpelEvent(ProcessInstanceEvent processInstanceEvent) {
        this.entering("ProcessInstanceDaoImpl.insertBpelEvent");
        BpelDAOConnectionImpl._insertBpelEvent(this.getSession(), (BpelEvent)processInstanceEvent, this.getProcess(), this);
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        this.entering("ProcessInstanceDaoImpl.getEventsFirstLastCount");
        Criteria criteria = this.getSession().createCriteria(HBpelEvent.class);
        criteria.add((Criterion)Restrictions.eq((String)"instance", (Object)this._instance));
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.min((String)"tstamp")).add((Projection)Projections.max((String)"tstamp")).add((Projection)Projections.count((String)"tstamp")));
        Object[] objectArray = (Object[])criteria.uniqueResult();
        ProcessInstanceDAO.EventsFirstLastCountTuple eventsFirstLastCountTuple = new ProcessInstanceDAO.EventsFirstLastCountTuple();
        eventsFirstLastCountTuple.first = (Date)objectArray[0];
        eventsFirstLastCountTuple.last = (Date)objectArray[1];
        eventsFirstLastCountTuple.count = (Integer)objectArray[2];
        return eventsFirstLastCountTuple;
    }

    public Collection<MessageExchangeDAO> getMessageExchanges() {
        ArrayList<MessageExchangeDAO> arrayList = new ArrayList<MessageExchangeDAO>();
        for (HMessageExchange hMessageExchange : this._instance.getMessageExchanges()) {
            arrayList.add(new MessageExchangeDaoImpl(this._sm, hMessageExchange));
        }
        return arrayList;
    }

    public long genMonotonic() {
        this.entering("ProcessInstanceDaoImpl.genMonotonic");
        long l = this._instance.getSequence() + 1L;
        this._instance.setSequence(l);
        return l;
    }

    protected void clearSelectors() {
        this.entering("ProcessInstanceDaoImpl.clearSelectors");
        Query query = this.getSession().createQuery(QRY_DELSELECTORS);
        query.setEntity(0, (Object)this._instance);
        query.executeUpdate();
    }

    public int getActivityFailureCount() {
        return this._instance.getActivityFailureCount();
    }

    public Date getActivityFailureDateTime() {
        return this._instance.getActivityFailureDateTime();
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        this.entering("ProcessInstanceDaoImpl.getActivityRecoveries");
        ArrayList<ActivityRecoveryDAO> arrayList = new ArrayList<ActivityRecoveryDAO>();
        Query query = this.getSession().createQuery(QRY_RECOVERIES);
        query.setLong(0, this._instance.getId().longValue());
        Iterator iterator = query.iterate();
        while (iterator.hasNext()) {
            arrayList.add(new ActivityRecoveryDaoImpl(this._sm, (HActivityRecovery)iterator.next()));
        }
        Hibernate.close((Iterator)iterator);
        return arrayList;
    }

    public void createActivityRecovery(String string, long l, String string2, Date date, Element element, String[] stringArray, int n) {
        Object object;
        this.entering("ProcessInstanceDaoImpl.createActivityRecovery");
        HActivityRecovery hActivityRecovery = new HActivityRecovery();
        hActivityRecovery.setInstance(this._instance);
        hActivityRecovery.setChannel(string);
        hActivityRecovery.setActivityId(l);
        hActivityRecovery.setReason(string2);
        hActivityRecovery.setDateTime(date);
        hActivityRecovery.setRetries(n);
        if (element != null) {
            object = new HLargeData(DOMUtils.domToString((Node)element));
            hActivityRecovery.setDetails((HLargeData)object);
            this.getSession().save(object);
        }
        object = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            object = (String)object + " " + stringArray[i];
        }
        hActivityRecovery.setActions((String)object);
        this.getSession().save((Object)hActivityRecovery);
        this._instance.setActivityFailureDateTime(date);
        this._instance.setActivityFailureCount(this._instance.getActivityFailureCount() + 1);
        this.getSession().update((Object)this._instance);
    }

    public void deleteActivityRecovery(String string) {
        this.entering("ProcessInstanceDaoImpl.deleteActivityRecovery");
        for (HActivityRecovery hActivityRecovery : this._instance.getActivityRecoveries()) {
            if (!hActivityRecovery.getChannel().equals(string)) continue;
            this.getSession().delete((Object)hActivityRecovery);
            this._instance.setActivityFailureCount(this._instance.getActivityFailureCount() - 1);
            this.getSession().update((Object)this._instance);
            return;
        }
    }

    public BpelDAOConnection getConnection() {
        this.entering("ProcessInstanceDaoImpl.getConnection");
        return new BpelDAOConnectionImpl(this._sm);
    }
}

