/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.FilteredInstanceDeletable;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.CriteriaBuilder;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.ProcessManagementDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.ql.HibernateInstancesQueryCompiler;
import org.apache.ode.ql.eval.skel.CommandEvaluator;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.BuilderFactory;
import org.apache.ode.ql.tree.nodes.Node;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.utils.SerializableUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunctionEx;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelDAOConnectionImpl
implements BpelDAOConnection,
FilteredInstanceDeletable {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionImpl.class);
    protected SessionManager _sm;

    public BpelDAOConnectionImpl(SessionManager sm) {
        this._sm = sm;
    }

    protected Session getSession() {
        return this._sm.getSession();
    }

    public MessageExchangeDAO createMessageExchange(char dir) {
        HMessageExchange mex = new HMessageExchange();
        mex.setDirection(dir);
        mex.setInsertTime(new Date(System.currentTimeMillis()));
        this.getSession().save((Object)mex);
        return new MessageExchangeDaoImpl(this._sm, mex);
    }

    public MessageExchangeDAO getMessageExchange(String mexid) {
        HMessageExchange mex = (HMessageExchange)this.getSession().get(HMessageExchange.class, (Serializable)new Long(mexid));
        return mex == null ? null : new MessageExchangeDaoImpl(this._sm, mex);
    }

    public ProcessDAO createProcess(QName pid, QName type, String guid, long version) {
        HProcess process = new HProcess();
        process.setProcessId(pid.toString());
        process.setTypeName(type.getLocalPart());
        process.setTypeNamespace(type.getNamespaceURI());
        process.setDeployDate(new Date());
        process.setGuid(guid);
        process.setVersion(version);
        this.getSession().save((Object)process);
        return new ProcessDaoImpl(this._sm, process);
    }

    public ProcessDAO createTransientProcess(Serializable id) {
        HProcess process = new HProcess();
        process.setId((Long)id);
        return new ProcessDaoImpl(this._sm, process);
    }

    public ProcessDAO getProcess(QName processId) {
        try {
            Criteria criteria = this.getSession().createCriteria(HProcess.class);
            criteria.add((Criterion)Expression.eq((String)"processId", (Object)processId.toString()));
            HProcess hprocess = (HProcess)criteria.uniqueResult();
            return hprocess == null ? null : new ProcessDaoImpl(this._sm, hprocess);
        }
        catch (HibernateException e) {
            __log.error((Object)"DbError", (Throwable)e);
            throw e;
        }
    }

    public void close() {
    }

    public ProcessInstanceDAO getInstance(Long instanceId) {
        return BpelDAOConnectionImpl._getInstance(this._sm, this.getSession(), instanceId);
    }

    public int getNumInstances(QName processId) {
        ProcessDAO process = this.getProcess(processId);
        if (process != null) {
            return process.getNumInstances();
        }
        return -1;
    }

    public ScopeDAO getScope(Long siidl) {
        return BpelDAOConnectionImpl._getScope(this._sm, this.getSession(), siidl);
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter criteria) {
        if (criteria.getLimit() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProcessInstanceDAO> daos = new ArrayList<ProcessInstanceDAO>();
        Iterator<HProcessInstance> iter = BpelDAOConnectionImpl._instanceQuery(this.getSession(), false, criteria);
        while (iter.hasNext()) {
            daos.add(new ProcessInstanceDaoImpl(this._sm, iter.next()));
        }
        return daos;
    }

    public int deleteInstances(InstanceFilter criteria, Set<ProcessConf.CLEANUP_CATEGORY> categories) {
        if (criteria.getLimit() == 0) {
            return 0;
        }
        List<HProcessInstance> instances = BpelDAOConnectionImpl._instanceQueryForList(this.getSession(), false, criteria);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Collected " + instances.size() + " instances to delete."));
        }
        if (!instances.isEmpty()) {
            ProcessDaoImpl process = (ProcessDaoImpl)this.createTransientProcess(instances.get(0).getProcessId());
            return process.deleteInstances(instances, categories);
        }
        return 0;
    }

    static Iterator<HProcessInstance> _instanceQuery(Session session, boolean countOnly, InstanceFilter filter) {
        return BpelDAOConnectionImpl._instanceQueryForList(session, countOnly, filter).iterator();
    }

    private static List<HProcessInstance> _instanceQueryForList(Session session, boolean countOnly, InstanceFilter filter) {
        CriteriaBuilder cb = new CriteriaBuilder();
        return cb.buildHQLQuery(session, filter).list();
    }

    static ProcessInstanceDAO _getInstance(SessionManager sm, Session session, Long iid) {
        HProcessInstance instance = (HProcessInstance)session.get(HProcessInstance.class, (Serializable)iid);
        return instance != null ? new ProcessInstanceDaoImpl(sm, instance) : null;
    }

    static ScopeDAO _getScope(SessionManager sm, Session session, Long siid) {
        HScope scope = (HScope)session.get(HScope.class, (Serializable)siid);
        return scope != null ? new ScopeDaoImpl(sm, scope) : null;
    }

    public void insertBpelEvent(BpelEvent event, ProcessDAO process, ProcessInstanceDAO instance) {
        BpelDAOConnectionImpl._insertBpelEvent(this._sm.getSession(), event, process, instance);
    }

    static void _insertBpelEvent(Session sess, BpelEvent event, ProcessDAO process, ProcessInstanceDAO instance) {
        HBpelEvent hevent = new HBpelEvent();
        hevent.setTstamp(new Timestamp(System.currentTimeMillis()));
        hevent.setType(BpelEvent.eventName((BpelEvent)event));
        hevent.setDetail(event.toString());
        if (process != null) {
            hevent.setProcess((HProcess)((ProcessDaoImpl)process).getHibernateObj());
        }
        if (instance != null) {
            hevent.setInstance((HProcessInstance)((ProcessInstanceDaoImpl)instance).getHibernateObj());
        }
        if (event instanceof ScopeEvent) {
            hevent.setScopeId(((ScopeEvent)event).getScopeId());
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(event);
            oos.flush();
            hevent.setData(bos.toByteArray());
        }
        catch (Throwable ex) {
            __log.fatal((Object)"InternalError: BpelEvent serialization failed.", ex);
        }
        sess.save((Object)hevent);
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        CriteriaBuilder cb = new CriteriaBuilder();
        Criteria crit = this.getSession().createCriteria(HBpelEvent.class);
        if (ifilter != null) {
            cb.buildCriteria(crit, efilter);
        }
        if (ifilter != null) {
            cb.buildCriteria(crit.createCriteria("instance"), ifilter);
        }
        crit.setFetchMode("tstamp", FetchMode.EAGER);
        crit.setProjection((Projection)Projections.property((String)"tstamp"));
        return crit.list();
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        CriteriaBuilder cb = new CriteriaBuilder();
        Criteria crit = this.getSession().createCriteria(HBpelEvent.class);
        if (efilter != null) {
            cb.buildCriteria(crit, efilter);
        }
        if (ifilter != null) {
            cb.buildCriteria(crit.createCriteria("instance"), ifilter);
        }
        List hevents = crit.list();
        ArrayList<BpelEvent> ret = new ArrayList<BpelEvent>(hevents.size());
        try {
            CollectionsX.transformEx(ret, (Collection)hevents, (UnaryFunctionEx)new UnaryFunctionEx<HBpelEvent, BpelEvent>(){

                public BpelEvent apply(HBpelEvent x) throws Exception {
                    return (BpelEvent)SerializableUtils.toObject((byte[])x.getData(), (ClassLoader)BpelEvent.class.getClassLoader());
                }
            });
        }
        catch (Exception ex) {
            __log.fatal((Object)"Internal error: unable to transform HBpelEvent", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return ret;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String expression) {
        Builder builder = BuilderFactory.getInstance().createBuilder();
        Node rootNode = builder.build((Object)expression);
        HibernateInstancesQueryCompiler compiler = new HibernateInstancesQueryCompiler();
        CommandEvaluator<List, Session> eval = compiler.compile((Query)rootNode);
        List instancesList = (List)eval.evaluate((Object)this.getSession());
        ArrayList<ProcessInstanceDAO> result = new ArrayList<ProcessInstanceDAO>(instancesList.size());
        for (HProcessInstance instance : instancesList) {
            result.add(this.getInstance(instance.getId()));
        }
        return result;
    }

    public Map<Long, Collection<CorrelationSetDAO>> getCorrelationSets(Collection<ProcessInstanceDAO> instances) {
        if (instances.size() == 0) {
            return new HashMap<Long, Collection<CorrelationSetDAO>>();
        }
        ArrayList<Long> iids = new ArrayList<Long>(instances.size());
        int i = 0;
        for (ProcessInstanceDAO dao : instances) {
            iids.add(dao.getInstanceId());
            ++i;
        }
        ArrayList csets = new ArrayList();
        int batchSize = 100;
        for (int index = 0; index < iids.size(); index += 100) {
            List subList = iids.subList(index, Math.min(index + 100, iids.size()));
            csets.addAll(this.getSession().getNamedQuery("SELECT_CORSETS_BY_INSTANCES").setParameterList("instances", subList).list());
        }
        HashMap<Long, Collection<CorrelationSetDAO>> map = new HashMap<Long, Collection<CorrelationSetDAO>>();
        for (HCorrelationSet cset : csets) {
            Long id = cset.getInstance().getId();
            ArrayList<CorrelationSetDaoImpl> existing = (ArrayList<CorrelationSetDaoImpl>)map.get(id);
            if (existing == null) {
                existing = new ArrayList<CorrelationSetDaoImpl>();
                map.put(id, existing);
            }
            existing.add(new CorrelationSetDaoImpl(this._sm, cset));
        }
        return map;
    }

    public Collection<CorrelationSetDAO> getActiveCorrelationSets() {
        ArrayList<CorrelationSetDAO> csetDaos = new ArrayList<CorrelationSetDAO>();
        List csets = this.getSession().getNamedQuery("SELECT_CORSETS_BY_PROCESS_STATES").setParameter("states", (Object)20).list();
        for (HCorrelationSet cset : csets) {
            csetDaos.add(new CorrelationSetDaoImpl(this._sm, cset));
        }
        return csetDaos;
    }

    public ProcessManagementDAO getProcessManagement() {
        return new ProcessManagementDaoImpl(this._sm);
    }
}

