/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CorrelatorMessageDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.MessageRouteDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrelatorDaoImpl
extends HibernateDao
implements CorrelatorDAO {
    static Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private static final String LOCK_SELECTORS = "update from HCorrelatorSelector as hs set hs.lock = hs.lock+1 where hs.processType = :processType";
    private static final String CHECK_SELECTORS = "from HCorrelatorSelector as hs where hs.processType = :processType and hs.correlator.correlatorId = :correlatorId";
    private static final String FLTR_SELECTORS = "from HCorrelatorSelector as hs where hs.processType = :processType and hs.correlator.correlatorId = :correlatorId";
    private static final String FLTR_SELECTORS_SUBQUERY = "from HCorrelatorSelector as hs where hs.processType = :processType and hs.correlatorId = (select hc.id from HCorrelator as hc where hc.correlatorId = :correlatorId )".intern();
    private static final String QRY_DELSELECTORS = "delete from HCorrelatorSelector where groupId = ? and instance = ?";
    private HCorrelator _hobj;

    public CorrelatorDaoImpl(SessionManager sessionManager, HCorrelator hCorrelator) {
        super(sessionManager, hCorrelator);
        this.entering("CorrelatorDaoImpl.CorrelatorDaoImpl");
        this._hobj = hCorrelator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchangeDAO dequeueMessage(CorrelationKeySet correlationKeySet) {
        this.entering("CorrelatorDaoImpl.dequeueMessage");
        MessageExchangeDaoImpl messageExchangeDaoImpl = null;
        String string = "dequeueMessage(" + correlationKeySet + "): ";
        __log.debug((Object)string);
        List list = correlationKeySet.findSubSets();
        Query query = this.getSession().createFilter(this._hobj.getMessageCorrelations(), this.generateUnmatchedQuery(list));
        for (int i = 0; i < list.size(); ++i) {
            query.setString("s" + i, ((CorrelationKeySet)list.get(i)).toCanonicalString());
        }
        Iterator iterator = query.iterate();
        try {
            if (!iterator.hasNext()) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(string + "did not find a MESSAGE entry."));
                }
            } else {
                HCorrelatorMessage hCorrelatorMessage = (HCorrelatorMessage)iterator.next();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(string + "found MESSAGE entry " + hCorrelatorMessage.getMessageExchange()));
                }
                messageExchangeDaoImpl = new MessageExchangeDaoImpl(this._sm, hCorrelatorMessage.getMessageExchange());
            }
        }
        finally {
            Hibernate.close((Iterator)iterator);
        }
        return messageExchangeDaoImpl;
    }

    public List<MessageRouteDAO> findRoute(CorrelationKeySet correlationKeySet) {
        ArrayList<MessageRouteDAO> arrayList = new ArrayList<MessageRouteDAO>();
        this.entering("CorrelatorDaoImpl.findRoute");
        String string = "findRoute(keySet=" + correlationKeySet + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)string);
        }
        String string2 = new QName(this._hobj.getProcess().getTypeNamespace(), this._hobj.getProcess().getTypeName()).toString();
        List list = correlationKeySet.findSubSets();
        Query query = this.getSession().createQuery(this.generateSelectorQuery(this._sm.canJoinForUpdate() ? "from HCorrelatorSelector as hs where hs.processType = :processType and hs.correlator.correlatorId = :correlatorId" : FLTR_SELECTORS_SUBQUERY, list));
        query.setString("processType", string2);
        query.setString("correlatorId", this._hobj.getCorrelatorId());
        for (int i = 0; i < list.size(); ++i) {
            query.setString("s" + i, ((CorrelationKeySet)list.get(i)).toCanonicalString());
        }
        query.setLockMode("hs", LockMode.UPGRADE);
        ArrayList<HProcessInstance> arrayList2 = new ArrayList<HProcessInstance>();
        for (HCorrelatorSelector hCorrelatorSelector : query.list()) {
            boolean bl;
            if (hCorrelatorSelector == null) continue;
            boolean bl2 = bl = hCorrelatorSelector.getRoute() == null || "one".equals(hCorrelatorSelector.getRoute());
            if (!"all".equals(hCorrelatorSelector.getRoute()) && (!bl || arrayList2.contains(hCorrelatorSelector.getInstance()))) continue;
            arrayList.add(new MessageRouteDaoImpl(this._sm, hCorrelatorSelector));
            arrayList2.add(hCorrelatorSelector.getInstance());
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(string + "found " + arrayList));
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Obtain record lock on " + this._hobj));
        }
        Query query2 = this.getSession().createQuery("from HCorrelator as hc where id = :id");
        query2.setLong("id", this._hobj.getId().longValue());
        query2.setLockMode("hc", LockMode.UPGRADE);
        query2.list();
        return arrayList;
    }

    private String generateUnmatchedQuery(List<CorrelationKeySet> list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() == 1) {
            stringBuffer.append(" where this.correlationKey = :s0");
        } else if (list.size() > 1) {
            stringBuffer.append(" where this.correlationKey in(");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(":s").append(i);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String generateSelectorQuery(String string, List<CorrelationKeySet> list) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (list.size() == 1) {
            stringBuffer.append(" and hs.correlationKey = :s0");
        } else if (list.size() > 1) {
            stringBuffer.append(" and hs.correlationKey in(");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(":s").append(i);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public void enqueueMessage(MessageExchangeDAO messageExchangeDAO, CorrelationKeySet correlationKeySet) {
        this.entering("CorrelatorDaoImpl.enqueueMessage");
        String string = "enqueueMessage(mex=" + ((MessageExchangeDaoImpl)messageExchangeDAO)._hobj.getId() + " keySet=" + correlationKeySet.toCanonicalString() + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)string);
        }
        for (CorrelationKeySet correlationKeySet2 : correlationKeySet.findSubSets()) {
            HCorrelatorMessage hCorrelatorMessage = new HCorrelatorMessage();
            hCorrelatorMessage.setCorrelator(this._hobj);
            hCorrelatorMessage.setCreated(new Date());
            hCorrelatorMessage.setMessageExchange((HMessageExchange)((MessageExchangeDaoImpl)messageExchangeDAO)._hobj);
            hCorrelatorMessage.setCorrelationKey(correlationKeySet2.toCanonicalString());
            this.getSession().save((Object)hCorrelatorMessage);
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)(string + "saved " + hCorrelatorMessage));
        }
    }

    public void addRoute(String string, ProcessInstanceDAO processInstanceDAO, int n, CorrelationKeySet correlationKeySet, String string2) {
        this.entering("CorrelatorDaoImpl.addRoute");
        String string3 = "addRoute(" + string + ", iid=" + processInstanceDAO.getInstanceId() + ", idx=" + n + ", ckeySet=" + correlationKeySet + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)string3);
        }
        HCorrelatorSelector hCorrelatorSelector = new HCorrelatorSelector();
        hCorrelatorSelector.setGroupId(string);
        hCorrelatorSelector.setIndex(n);
        hCorrelatorSelector.setLock(0);
        hCorrelatorSelector.setCorrelationKey(correlationKeySet.toCanonicalString());
        hCorrelatorSelector.setInstance((HProcessInstance)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
        hCorrelatorSelector.setProcessType(processInstanceDAO.getProcess().getType().toString());
        hCorrelatorSelector.setCorrelator(this._hobj);
        hCorrelatorSelector.setCreated(new Date());
        hCorrelatorSelector.setRoute(string2);
        this.getSession().save((Object)hCorrelatorSelector);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(string3 + "saved " + hCorrelatorSelector));
        }
    }

    public boolean checkRoute(CorrelationKeySet correlationKeySet) {
        this.entering("CorrelatorDaoImpl.checkRoute");
        Query query = this.getSession().getNamedQuery("SELECT_MESSAGE_ROUTE");
        query.setEntity("corr", (Object)this._hobj);
        query.setString("ckey", correlationKeySet.toCanonicalString());
        query.setReadOnly(true);
        return query.list().isEmpty();
    }

    public String getCorrelatorId() {
        return this._hobj.getCorrelatorId();
    }

    public void setCorrelatorId(String string) {
        this._hobj.setCorrelatorId(string);
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        this.entering("CorrelatorDaoImpl.removeRoutes");
        String string2 = "removeRoutes(" + string + ", iid=" + processInstanceDAO.getInstanceId() + "): ";
        __log.debug((Object)string2);
        Session session = this.getSession();
        Query query = session.createQuery(QRY_DELSELECTORS);
        query.setString(0, string);
        query.setEntity(1, (Object)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
        int n = query.executeUpdate();
        session.flush();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(string2 + "deleted " + n + " rows"));
        }
    }

    public Collection<CorrelatorMessageDAO> getAllMessages() {
        ArrayList<CorrelatorMessageDAO> arrayList = new ArrayList<CorrelatorMessageDAO>();
        for (HCorrelatorMessage hCorrelatorMessage : this._hobj.getMessageCorrelations()) {
            arrayList.add(new CorrelatorMessageDaoImpl(this._sm, hCorrelatorMessage));
        }
        return arrayList;
    }

    public Collection<MessageRouteDAO> getAllRoutes() {
        ArrayList<MessageRouteDAO> arrayList = new ArrayList<MessageRouteDAO>();
        for (HCorrelatorSelector hCorrelatorSelector : this._hobj.getSelectors()) {
            arrayList.add(new MessageRouteDaoImpl(this._sm, hCorrelatorSelector));
        }
        return arrayList;
    }
}

