/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Iterator;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.DOMUtils;
import org.hibernate.Query;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlDataDaoImpl
extends HibernateDao
implements XmlDataDAO {
    private static final String QUERY_PROPERTY = "from " + HVariableProperty.class.getName() + " as p where p.xmlData.id = ? and p.name = ?";
    private HXmlData _data;
    private Node _node;

    public XmlDataDaoImpl(SessionManager sessionManager, HXmlData hXmlData) {
        super(sessionManager, hXmlData);
        this.entering("XmlDataDaoImpl.XmlDataDaoImpl");
        this._data = hXmlData;
    }

    public boolean isNull() {
        this.entering("XmlDataDaoImpl.isNull");
        return this._data.getSimpleValue() == null && (this._data.getData() == null || this._data.getData().length == 0);
    }

    public Node get() {
        this.entering("XmlDataDaoImpl.get");
        if (this._node == null) {
            this._node = this.prepare();
        }
        return this._node;
    }

    public void remove() {
    }

    public void set(Node node) {
        this.entering("XmlDataDaoImpl.set");
        this._node = node;
        if (node != null && node.getNamespaceURI() == null && "temporary-simple-type-wrapper".equals(node.getLocalName())) {
            this._data.setSimpleType(true);
            String string = this._node.getTextContent();
            if (string.length() <= 255) {
                this._data.setSimpleValue(string);
                this._data.setData(null);
            } else {
                this._data.setData(string.getBytes());
                this._data.setSimpleValue(null);
            }
        } else if (node instanceof Element) {
            this._data.setSimpleType(false);
            this._data.setData(DOMUtils.domToString((Node)this._node).getBytes());
            this._data.setSimpleValue(null);
        } else {
            this._data.setSimpleType(true);
            this._data.setSimpleValue(this._node.getNodeValue());
            this._data.setData(null);
        }
        this.getSession().saveOrUpdate((Object)this._data);
        this.leaving("XmlDataDaoImpl.set");
    }

    public String getProperty(String string) {
        this.entering("XmlDataDaoImpl.getProperty");
        HVariableProperty hVariableProperty = this._getProperty(string);
        return hVariableProperty == null ? null : hVariableProperty.getValue();
    }

    public void setProperty(String string, String string2) {
        this.entering("XmlDataDaoImpl.setProperty");
        HVariableProperty hVariableProperty = this._getProperty(string);
        if (hVariableProperty == null) {
            hVariableProperty = new HVariableProperty(this._data, string, string2);
            this.getSession().save((Object)hVariableProperty);
        } else {
            hVariableProperty.setValue(string2);
            this.getSession().update((Object)hVariableProperty);
        }
    }

    public ScopeDAO getScopeDAO() {
        this.entering("XmlDataDaoImpl.getScopeDAO");
        return new ScopeDaoImpl(this._sm, this._data.getScope());
    }

    private HVariableProperty _getProperty(String string) {
        this.entering("XmlDataDaoImpl._getProperty");
        Query query = this.getSession().createQuery(QUERY_PROPERTY);
        query.setLong(0, this._data.getId().longValue());
        query.setString(1, string);
        Iterator iterator = query.iterate();
        return iterator.hasNext() ? (HVariableProperty)iterator.next() : null;
    }

    private Node prepare() {
        if (this._data.isSimpleType()) {
            String string;
            if (this._data.getSimpleValue() != null) {
                string = this._data.getSimpleValue();
            } else {
                if (this._data.getData() == null || this._data.getData().length == 0) {
                    return null;
                }
                string = new String(this._data.getData());
            }
            Document document = DOMUtils.newDocument();
            Element element = document.createElement("temporary-simple-type-wrapper");
            Text text = document.createTextNode(string);
            document.appendChild(element);
            element.appendChild(text);
            return text;
        }
        if (this._data.getData() == null || this._data.getData().length == 0) {
            return null;
        }
        String string = new String(this._data.getData());
        try {
            return DOMUtils.stringToDOM((String)string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getName() {
        return this._data.getName();
    }
}

