/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel.hobj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.usertype.UserType;

public class GZipDataType
implements UserType {
    private static final Log log = LogFactory.getLog(GZipDataType.class);
    public static final int[] SQL_TYPES = new int[]{2004};
    public static final Class RETURNED_CLASS = new byte[0].getClass();
    public static final byte[] GZIP_PREFIX = new byte[]{1, 2, 3, 4, 3, 2, 1, 0};
    private static long _totalBytesBefore = 0L;
    private static long _totalBytesAfter = 0L;
    private static volatile long _lastLogTime = 0L;
    private static final Object STATS_LOCK = new Object();
    private static volatile boolean _compressionEnabled = System.getProperty("org.apache.ode.daohib.bpel.hobj.GZipDataType.enabled", "true").equalsIgnoreCase("true");

    public Object assemble(Serializable serializable, Object object) {
        return serializable;
    }

    public Serializable disassemble(Object object) {
        return (Serializable)object;
    }

    public Object deepCopy(Object object) {
        if (object == null) {
            return null;
        }
        return ((byte[])object).clone();
    }

    public boolean equals(Object object, Object object2) {
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null && byArray2 != null) {
            return false;
        }
        if (byArray != null && byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        byte[] byArray = (byte[])object;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i];
        }
        return n;
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, Object object) throws SQLException {
        if (stringArray.length != 1) {
            throw new IllegalStateException("Expected a single column name instead of " + stringArray.length);
        }
        byte[] byArray = resultSet.getBytes(stringArray[0]);
        if (byArray == null) {
            return null;
        }
        if (byArray.length >= GZIP_PREFIX.length) {
            boolean bl = true;
            for (int i = 0; i < GZIP_PREFIX.length; ++i) {
                if (byArray[i] == GZIP_PREFIX[i]) continue;
                bl = false;
                break;
            }
            if (bl) {
                byArray = GZipDataType.gunzip(new ByteArrayInputStream(byArray, GZIP_PREFIX.length, byArray.length - GZIP_PREFIX.length));
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        byte[] byArray = (byte[])object;
        if (byArray != null) {
            long l;
            Object object2 = STATS_LOCK;
            synchronized (object2) {
                if (_totalBytesBefore > Integer.MAX_VALUE) {
                    _totalBytesAfter = _totalBytesAfter * 100L / _totalBytesBefore;
                    _totalBytesBefore = 100L;
                }
                _totalBytesBefore += (long)byArray.length;
            }
            if (byArray != null && byArray.length > 100 && _compressionEnabled) {
                object2 = new ByteArrayOutputStream(byArray.length);
                for (int i = 0; i < GZIP_PREFIX.length; ++i) {
                    ((ByteArrayOutputStream)object2).write(GZIP_PREFIX[i]);
                }
                GZipDataType.gzip((byte[])object, (OutputStream)object2);
                byte[] byArray2 = ((ByteArrayOutputStream)object2).toByteArray();
                if (byArray2.length * 100 / byArray.length < 99) {
                    byArray = byArray2;
                }
            }
            object2 = STATS_LOCK;
            synchronized (object2) {
                _totalBytesAfter += (long)byArray.length;
            }
            if (log.isDebugEnabled() && _lastLogTime + 5000L < (l = System.currentTimeMillis())) {
                log.debug((Object)("Average compression ratio: " + _totalBytesAfter * 100L / _totalBytesBefore + "%"));
                _lastLogTime = l;
            }
        }
        preparedStatement.setBytes(n, byArray);
    }

    public Object replace(Object object, Object object2, Object object3) {
        return object;
    }

    public Class returnedClass() {
        return RETURNED_CLASS;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public static void gzip(byte[] byArray, OutputStream outputStream) {
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
            gZIPOutputStream.write(byArray, 0, byArray.length);
            gZIPOutputStream.finish();
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] gunzip(InputStream inputStream) {
        try {
            int n;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
            byte[] byArray = new byte[4096];
            while ((n = gZIPInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            gZIPInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

