/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.processor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.processor.ExceptionProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerException;
import org.apache.olingo.server.api.uri.UriInfo;

public class DefaultProcessor
implements MetadataProcessor,
ServiceDocumentProcessor,
ExceptionProcessor {
    private OData odata;
    private Edm edm;

    @Override
    public void init(OData odata, Edm edm) {
        this.odata = odata;
        this.edm = edm;
    }

    @Override
    public void readServiceDocument(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
            response.setContent(serializer.serviceDocument(this.edm, request.getRawBaseUri()));
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
        catch (ODataSerializerException e) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public void readMetadata(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
            response.setContent(serializer.metadataDocument(this.edm));
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
        catch (ODataSerializerException e) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public void processException(ODataRequest request, ODataResponse response, ODataServerError serverError, ContentType requestedContentType) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
            InputStream responseEntity = serializer.error(serverError);
            response.setStatusCode(serverError.getStatusCode());
            response.setContent(responseEntity);
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
        catch (Exception e) {
            String responseContent = "{\"error\":{\"code\":null,\"message\":\"An unexpected exception occurred during error processing with message: " + e.getMessage() + "\"}}";
            response.setContent(new ByteArrayInputStream(responseContent.getBytes()));
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            response.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
        }
    }
}

