/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api;

import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.olingo.commons.api.ODataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ODataTranslatedException
extends ODataException {
    private static final long serialVersionUID = -1210541002198287561L;
    private static final Logger LOG = LoggerFactory.getLogger(ODataTranslatedException.class);
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    protected static final String DEFAULT_SERVER_BUNDLE_NAME = "server-core-exceptions-i18n";
    private MessageKey messageKey;
    private Object[] parameters;

    protected ODataTranslatedException(String developmentMessage, MessageKey messageKey, String ... parameters) {
        super(developmentMessage);
        this.messageKey = messageKey;
        this.parameters = parameters;
    }

    protected ODataTranslatedException(String developmentMessage, Throwable cause, MessageKey messageKey, String ... parameters) {
        super(developmentMessage, cause);
        this.messageKey = messageKey;
        this.parameters = parameters;
    }

    public String getLocalizedMessage() {
        return this.getTranslatedMessage(DEFAULT_LOCALE).getMessage();
    }

    public String toString() {
        return this.getMessage();
    }

    public MessageKey getMessageKey() {
        return this.messageKey;
    }

    public ODataErrorMessage getTranslatedMessage(Locale locale) {
        if (this.messageKey == null) {
            return new ODataErrorMessage(this.getMessage(), DEFAULT_LOCALE);
        }
        ResourceBundle bundle = this.createResourceBundle(locale);
        if (bundle == null) {
            return new ODataErrorMessage(this.getMessage(), DEFAULT_LOCALE);
        }
        return this.buildMessage(bundle, locale);
    }

    protected abstract String getBundleName();

    private ResourceBundle createResourceBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.getBundleName(), locale == null ? DEFAULT_LOCALE : locale);
        }
        catch (MissingResourceException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ODataErrorMessage buildMessage(ResourceBundle bundle, Locale locale) {
        String message = null;
        try {
            message = bundle.getString(((Object)((Object)this)).getClass().getSimpleName() + '.' + this.messageKey.getKey());
            StringBuilder builder = new StringBuilder();
            Formatter f = new Formatter(builder, locale);
            f.format(message, this.parameters);
            f.close();
            Locale usedLocale = bundle.getLocale();
            if (Locale.ROOT.equals(usedLocale)) {
                usedLocale = DEFAULT_LOCALE;
            }
            return new ODataErrorMessage(builder.toString(), usedLocale);
        }
        catch (MissingResourceException e) {
            return new ODataErrorMessage("Missing message for key '" + this.messageKey.getKey() + "'!", DEFAULT_LOCALE);
        }
        catch (MissingFormatArgumentException e) {
            return new ODataErrorMessage("Missing replacement for place holder in message '" + message + "' for following arguments '" + Arrays.toString(this.parameters) + "'!", DEFAULT_LOCALE);
        }
    }

    public class ODataErrorMessage {
        String message;
        Locale locale;

        public ODataErrorMessage(String message, Locale usedLocale) {
            this.message = message;
            this.locale = usedLocale;
        }

        public String getMessage() {
            return this.message;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    public static interface MessageKey {
        public String getKey();
    }
}

