/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.serializer;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

public class EntityCollectionSerializerOptions {
    private ContextURL contextURL;
    private CountOption count;
    private ExpandOption expand;
    private SelectOption select;

    public ContextURL getContextURL() {
        return this.contextURL;
    }

    public CountOption getCount() {
        return this.count;
    }

    public ExpandOption getExpand() {
        return this.expand;
    }

    public SelectOption getSelect() {
        return this.select;
    }

    public static Builder with() {
        return new Builder();
    }

    public static final class Builder {
        private EntityCollectionSerializerOptions options = new EntityCollectionSerializerOptions();

        private Builder() {
        }

        public Builder contextURL(ContextURL contextURL) {
            this.options.contextURL = contextURL;
            return this;
        }

        public Builder count(CountOption count) {
            this.options.count = count;
            return this;
        }

        public Builder expand(ExpandOption expand) {
            this.options.expand = expand;
            return this;
        }

        public Builder select(SelectOption select) {
            this.options.select = select;
            return this;
        }

        public EntityCollectionSerializerOptions build() {
            return this.options;
        }
    }
}

