/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.CommonCUDRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.CommonUpdateType;
import org.apache.olingo.client.api.communication.request.cud.ODataDeleteRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityCreateRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityUpdateRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataPropertyUpdateRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataValueUpdateRequest;
import org.apache.olingo.client.api.communication.request.streamed.ODataMediaEntityCreateRequest;
import org.apache.olingo.client.api.communication.request.streamed.ODataMediaEntityUpdateRequest;
import org.apache.olingo.client.api.communication.request.streamed.ODataStreamUpdateRequest;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.cud.ODataDeleteRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataEntityCreateRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataEntityUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataPropertyUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataValueUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.streamed.ODataMediaEntityCreateRequestImpl;
import org.apache.olingo.client.core.communication.request.streamed.ODataMediaEntityUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.streamed.ODataStreamUpdateRequestImpl;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;

public abstract class AbstractCUDRequestFactory<UT extends CommonUpdateType>
implements CommonCUDRequestFactory<UT> {
    protected final CommonODataClient<?> client;

    protected AbstractCUDRequestFactory(CommonODataClient<?> client) {
        this.client = client;
    }

    public <E extends CommonODataEntity> ODataEntityCreateRequest<E> getEntityCreateRequest(URI targetURI, E entity) {
        return new ODataEntityCreateRequestImpl(this.client, targetURI, entity);
    }

    public <E extends CommonODataEntity> ODataEntityUpdateRequest<E> getEntityUpdateRequest(URI targetURI, UT type, E changes) {
        ODataEntityUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataEntityUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, changes);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataEntityUpdateRequestImpl(this.client, type.getMethod(), targetURI, changes);
        }
        return req;
    }

    public <E extends CommonODataEntity> ODataEntityUpdateRequest<E> getEntityUpdateRequest(UT type, E entity) {
        ODataEntityUpdateRequestImpl req;
        if (entity.getEditLink() == null) {
            throw new IllegalArgumentException("No edit link found");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataEntityUpdateRequestImpl(this.client, HttpMethod.POST, entity.getEditLink(), entity);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataEntityUpdateRequestImpl(this.client, type.getMethod(), entity.getEditLink(), entity);
        }
        return req;
    }

    public ODataValueUpdateRequest getValueUpdateRequest(URI targetURI, UT type, ODataPrimitiveValue value) {
        ODataValueUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataValueUpdateRequestImpl(this.client, HttpMethod.POST, URIUtils.addValueSegment((URI)targetURI), value);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataValueUpdateRequestImpl(this.client, type.getMethod(), URIUtils.addValueSegment((URI)targetURI), value);
        }
        return req;
    }

    public ODataPropertyUpdateRequest getPropertyPrimitiveValueUpdateRequest(URI targetURI, CommonODataProperty property) {
        ODataPropertyUpdateRequestImpl req;
        if (!property.hasPrimitiveValue()) {
            throw new IllegalArgumentException("A primitive value is required");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, property);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.PUT, targetURI, property);
        }
        return req;
    }

    public ODataPropertyUpdateRequest getPropertyComplexValueUpdateRequest(URI targetURI, UT type, CommonODataProperty property) {
        ODataPropertyUpdateRequestImpl req;
        if (!property.hasComplexValue()) {
            throw new IllegalArgumentException("A complex value is required");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, property);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataPropertyUpdateRequestImpl(this.client, type.getMethod(), targetURI, property);
        }
        return req;
    }

    public ODataPropertyUpdateRequest getPropertyCollectionValueUpdateRequest(URI targetURI, CommonODataProperty property) {
        ODataPropertyUpdateRequestImpl req;
        if (!property.hasCollectionValue()) {
            throw new IllegalArgumentException("A collection value is required");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, property);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.PUT, targetURI, property);
        }
        return req;
    }

    public ODataDeleteRequest getDeleteRequest(URI targetURI) {
        ODataDeleteRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataDeleteRequestImpl(this.client, HttpMethod.POST, targetURI);
            req.setXHTTPMethod(HttpMethod.DELETE.name());
        } else {
            req = new ODataDeleteRequestImpl(this.client, HttpMethod.DELETE, targetURI);
        }
        return req;
    }

    public <E extends CommonODataEntity> ODataMediaEntityCreateRequest<E> getMediaEntityCreateRequest(URI targetURI, InputStream media) {
        return new ODataMediaEntityCreateRequestImpl(this.client, targetURI, media);
    }

    public ODataStreamUpdateRequest getStreamUpdateRequest(URI targetURI, InputStream stream) {
        ODataStreamUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataStreamUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, stream);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataStreamUpdateRequestImpl(this.client, HttpMethod.PUT, targetURI, stream);
        }
        return req;
    }

    public <E extends CommonODataEntity> ODataMediaEntityUpdateRequest<E> getMediaEntityUpdateRequest(URI editURI, InputStream media) {
        ODataMediaEntityUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataMediaEntityUpdateRequestImpl(this.client, HttpMethod.POST, URIUtils.addValueSegment((URI)editURI), media);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataMediaEntityUpdateRequestImpl(this.client, HttpMethod.PUT, URIUtils.addValueSegment((URI)editURI), media);
        }
        return req;
    }
}

