/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.CommonRetrieveRequestFactory;
import org.apache.olingo.client.api.communication.request.retrieve.EdmMetadataRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataMediaRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataRawRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataServiceDocumentRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataValueRequest;
import org.apache.olingo.client.core.communication.request.retrieve.EdmMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataMediaRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataRawRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataServiceDocumentRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataValueRequestImpl;
import org.apache.olingo.client.core.uri.URIUtils;

public abstract class AbstractRetrieveRequestFactory
implements CommonRetrieveRequestFactory {
    protected final CommonODataClient<?> client;

    protected AbstractRetrieveRequestFactory(CommonODataClient<?> client) {
        this.client = client;
    }

    public ODataValueRequest getValueRequest(URI uri) {
        return new ODataValueRequestImpl(this.client, uri);
    }

    public ODataValueRequest getPropertyValueRequest(URI uri) {
        return this.getValueRequest(URIUtils.addValueSegment((URI)uri));
    }

    public ODataMediaRequest getMediaRequest(URI uri) {
        return new ODataMediaRequestImpl(this.client, uri);
    }

    public ODataMediaRequest getMediaEntityRequest(URI uri) {
        return this.getMediaRequest(URIUtils.addValueSegment((URI)uri));
    }

    public ODataRawRequest getRawRequest(URI uri) {
        return new ODataRawRequestImpl(this.client, uri);
    }

    public EdmMetadataRequest getMetadataRequest(String serviceRoot) {
        return new EdmMetadataRequestImpl(this.client, serviceRoot, this.client.newURIBuilder(serviceRoot).appendMetadataSegment().build());
    }

    public ODataServiceDocumentRequest getServiceDocumentRequest(String serviceRoot) {
        return new ODataServiceDocumentRequestImpl(this.client, StringUtils.isNotBlank((CharSequence)serviceRoot) && serviceRoot.endsWith("/") ? this.client.newURIBuilder(serviceRoot).build() : this.client.newURIBuilder(serviceRoot + "/").build());
    }
}

