/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve.v4;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.XMLMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Annotations;
import org.apache.olingo.client.api.edm.xml.v4.Include;
import org.apache.olingo.client.api.edm.xml.v4.Reference;
import org.apache.olingo.client.api.edm.xml.v4.Schema;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.v4.XMLMetadataRequestImpl;
import org.apache.olingo.client.core.edm.xml.AbstractSchema;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationsImpl;
import org.apache.olingo.client.core.edm.xml.v4.SchemaImpl;

public class XMLMetadataRequestImpl
extends AbstractMetadataRequestImpl<XMLMetadata>
implements XMLMetadataRequest {
    XMLMetadataRequestImpl(ODataClient odataClient, URI uri) {
        super((CommonODataClient)odataClient, uri);
    }

    public ODataRetrieveResponse<XMLMetadata> execute() {
        SingleXMLMetadatRequestImpl rootReq = new SingleXMLMetadatRequestImpl(this, (ODataClient)this.odataClient, this.uri);
        ODataRetrieveResponse rootRes = rootReq.execute();
        XMLMetadataResponseImpl response = new XMLMetadataResponseImpl(this, this.odataClient, this.httpClient, rootReq.getHttpResponse(), (org.apache.olingo.client.api.edm.xml.v4.XMLMetadata)rootRes.getBody(), null);
        for (Reference reference : ((org.apache.olingo.client.api.edm.xml.v4.XMLMetadata)rootRes.getBody()).getReferences()) {
            SingleXMLMetadatRequestImpl includeReq = new SingleXMLMetadatRequestImpl(this, (ODataClient)this.odataClient, this.odataClient.newURIBuilder(reference.getUri().toASCIIString()).build());
            org.apache.olingo.client.api.edm.xml.v4.XMLMetadata includeMetadata = (org.apache.olingo.client.api.edm.xml.v4.XMLMetadata)includeReq.execute().getBody();
            for (Include include : reference.getIncludes()) {
                Schema includedSchema = includeMetadata.getSchema(include.getNamespace());
                if (includedSchema == null) continue;
                response.getBody().getSchemas().add(includedSchema);
                if (!StringUtils.isNotBlank((CharSequence)include.getAlias())) continue;
                ((AbstractSchema)includedSchema).setAlias(include.getAlias());
            }
            for (Include include : reference.getIncludeAnnotations()) {
                for (Schema schema : includeMetadata.getSchemas()) {
                    SchemaImpl forInclusion = new SchemaImpl();
                    forInclusion.setNamespace(schema.getNamespace());
                    forInclusion.setAlias(schema.getAlias());
                    for (Annotations annotationGroup : ((SchemaImpl)schema).getAnnotationGroups()) {
                        if (!StringUtils.isBlank((CharSequence)include.getTargetNamespace()) && !include.getTargetNamespace().equals(StringUtils.substringBeforeLast((String)annotationGroup.getTarget(), (String)".")) || !StringUtils.isBlank((CharSequence)include.getQualifier()) && !include.getQualifier().equals(annotationGroup.getQualifier())) continue;
                        AnnotationsImpl toBeIncluded = new AnnotationsImpl();
                        toBeIncluded.setTarget(annotationGroup.getTarget());
                        toBeIncluded.setQualifier(annotationGroup.getQualifier());
                        for (Annotation annotation : annotationGroup.getAnnotations()) {
                            if (!include.getTermNamespace().equals(StringUtils.substringBeforeLast((String)annotation.getTerm(), (String)"."))) continue;
                            toBeIncluded.getAnnotations().add(annotation);
                        }
                        forInclusion.getAnnotationGroups().add(toBeIncluded);
                    }
                    if (forInclusion.getAnnotationGroups().isEmpty()) continue;
                    response.getBody().getSchemas().add(forInclusion);
                }
            }
        }
        return response;
    }
}

