/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.streamed;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.ODataBatchConstants;
import org.apache.olingo.client.api.communication.request.ODataPayloadManager;
import org.apache.olingo.client.api.communication.request.ODataStreamedRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.communication.request.batch.CommonODataBatchRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.Wrapper;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;

public abstract class AbstractODataStreamedRequest<V extends ODataResponse, T extends ODataPayloadManager<V>>
extends AbstractODataRequest
implements ODataStreamedRequest<V, T> {
    protected ODataPayloadManager<V> payloadManager;
    protected final Wrapper<Future<HttpResponse>> futureWrapper = new Wrapper();

    public AbstractODataStreamedRequest(CommonODataClient<?> odataClient, HttpMethod method, URI uri) {
        super(odataClient, method, uri);
        this.setAccept(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString());
        this.setContentType(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString());
    }

    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultMediaFormat();
    }

    protected abstract T getPayloadManager();

    public T payloadManager() {
        this.payloadManager = this.getPayloadManager();
        if (URIUtils.shouldUseRepeatableHttpBodyEntry((CommonODataClient)this.odataClient)) {
            this.futureWrapper.setWrapped(this.odataClient.getConfiguration().getExecutor().submit(new /* Unavailable Anonymous Inner Class!! */));
        } else {
            ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity((CommonODataClient)this.odataClient, (InputStream)this.payloadManager.getBody()));
            this.futureWrapper.setWrapped(this.odataClient.getConfiguration().getExecutor().submit(new /* Unavailable Anonymous Inner Class!! */));
        }
        return (T)this.payloadManager;
    }

    public void batch(CommonODataBatchRequest req) {
        this.batch(req, null);
    }

    public void batch(CommonODataBatchRequest req, String contentId) {
        InputStream input = this.getPayloadManager().getBody();
        try {
            this.getPayloadManager().finalizeBody();
            req.rawAppend(this.toByteArray());
            if (StringUtils.isNotBlank((CharSequence)contentId)) {
                req.rawAppend((ODataBatchConstants.CHANGESET_CONTENT_ID_NAME + ": " + contentId).getBytes());
                req.rawAppend(ODataStreamer.CRLF);
            }
            req.rawAppend(ODataStreamer.CRLF);
            try {
                req.rawAppend(IOUtils.toByteArray((InputStream)input));
            }
            catch (Exception e) {
                LOG.debug("Invalid stream", (Throwable)e);
                req.rawAppend(new byte[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    static /* synthetic */ CommonODataClient access$000(AbstractODataStreamedRequest x0) {
        return x0.odataClient;
    }

    static /* synthetic */ HttpUriRequest access$100(AbstractODataStreamedRequest x0) {
        return x0.request;
    }

    static /* synthetic */ HttpResponse access$200(AbstractODataStreamedRequest x0) {
        return x0.doExecute();
    }

    static /* synthetic */ HttpResponse access$300(AbstractODataStreamedRequest x0) {
        return x0.doExecute();
    }
}

