/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.v4;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.header.ODataPreferences;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.v4.AsyncRequestWrapper;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.communication.response.v4.AsyncResponseWrapper;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.communication.request.AbstractRequest;
import org.apache.olingo.client.core.communication.request.v4.AsyncRequestException;
import org.apache.olingo.client.core.communication.request.v4.AsyncRequestWrapperImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.slf4j.Logger;

public class AsyncRequestWrapperImpl<R extends ODataResponse>
extends AbstractRequest
implements AsyncRequestWrapper<R> {
    protected static final int MAX_RETRY = 5;
    protected final ODataClient odataClient;
    protected final ODataRequest odataRequest;
    protected final HttpClient httpClient;
    protected final HttpUriRequest request;
    protected final URI uri;

    protected AsyncRequestWrapperImpl(ODataClient odataClient, ODataRequest odataRequest) {
        this.odataRequest = odataRequest;
        this.odataRequest.setAccept(this.odataRequest.getAccept());
        this.odataRequest.setContentType(this.odataRequest.getContentType());
        this.extendHeader(HeaderName.prefer.toString(), new ODataPreferences(ODataServiceVersion.V40).respondAsync());
        this.odataClient = odataClient;
        HttpMethod method = odataRequest.getMethod();
        this.uri = odataRequest.getURI();
        HttpClient _httpClient = odataClient.getConfiguration().getHttpClientFactory().create(method, this.uri);
        if (odataClient.getConfiguration().isGzipCompression()) {
            _httpClient = new DecompressingHttpClient(_httpClient);
        }
        this.httpClient = _httpClient;
        this.request = odataClient.getConfiguration().getHttpUriRequestFactory().create(method, this.uri);
    }

    public final AsyncRequestWrapper<R> wait(int waitInSeconds) {
        this.extendHeader(HeaderName.prefer.toString(), new ODataPreferences(ODataServiceVersion.V40).wait(waitInSeconds));
        return this;
    }

    public final AsyncRequestWrapper<R> callback(URI url) {
        this.extendHeader(HeaderName.prefer.toString(), new ODataPreferences(ODataServiceVersion.V40).callback(url.toASCIIString()));
        return this;
    }

    protected final void extendHeader(String headerName, String headerValue) {
        StringBuilder extended = new StringBuilder();
        if (this.odataRequest.getHeaderNames().contains(headerName)) {
            extended.append(this.odataRequest.getHeader(headerName)).append(", ");
        }
        this.odataRequest.addCustomHeader(headerName, extended.append(headerValue).toString());
    }

    public AsyncResponseWrapper<R> execute() {
        return new AsyncResponseWrapperImpl(this, this.doExecute());
    }

    protected HttpResponse doExecute() {
        for (String key : this.odataRequest.getHeaderNames()) {
            String value = this.odataRequest.getHeader(key);
            this.request.addHeader(key, value);
            LOG.debug("HTTP header being sent {}: {}", (Object)key, (Object)value);
        }
        return this.executeHttpRequest(this.httpClient, this.request);
    }

    protected final HttpResponse checkMonitor(URI location) {
        if (location == null) {
            throw new AsyncRequestException("Invalid async request response. Missing monitor URL");
        }
        HttpUriRequest monitor = this.odataClient.getConfiguration().getHttpUriRequestFactory().create(HttpMethod.GET, location);
        return this.executeHttpRequest(this.httpClient, monitor);
    }

    protected final HttpResponse executeHttpRequest(HttpClient client, HttpUriRequest req) {
        HttpResponse response;
        try {
            response = client.execute(req);
        }
        catch (IOException e) {
            throw new HttpClientException((Throwable)e);
        }
        catch (RuntimeException e) {
            req.abort();
            throw new HttpClientException((Throwable)e);
        }
        this.checkResponse((CommonODataClient)this.odataClient, response, this.odataRequest.getAccept());
        return response;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

