/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.data.ServiceDocumentItem;

public class ServiceDocumentImpl
implements ServiceDocument {
    private String title;
    private final List<ServiceDocumentItem> entitySets = new ArrayList();
    private final List<ServiceDocumentItem> functionImports = new ArrayList();
    private final List<ServiceDocumentItem> singletons = new ArrayList();
    private final List<ServiceDocumentItem> relatedServiceDocuments = new ArrayList();
    private String metadata;

    public URI getBaseURI() {
        URI baseURI = null;
        if (this.metadata != null) {
            String metadataURI = this.getMetadata();
            baseURI = URI.create(metadataURI.substring(0, metadataURI.indexOf("$metadata")));
        }
        return baseURI;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected ServiceDocumentItem getByName(List<ServiceDocumentItem> elements, String name) {
        ServiceDocumentItem result = null;
        for (ServiceDocumentItem element : elements) {
            if (!name.equals(element.getName())) continue;
            result = element;
        }
        return result;
    }

    public List<ServiceDocumentItem> getEntitySets() {
        return this.entitySets;
    }

    public ServiceDocumentItem getEntitySetByName(String name) {
        return this.getByName(this.getEntitySets(), name);
    }

    public List<ServiceDocumentItem> getFunctionImports() {
        return this.functionImports;
    }

    public ServiceDocumentItem getFunctionImportByName(String name) {
        return this.getByName(this.getFunctionImports(), name);
    }

    public List<ServiceDocumentItem> getSingletons() {
        return this.singletons;
    }

    public ServiceDocumentItem getSingletonByName(String name) {
        return this.getByName(this.getSingletons(), name);
    }

    public List<ServiceDocumentItem> getRelatedServiceDocuments() {
        return this.relatedServiceDocuments;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

