/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Annotations;
import org.apache.olingo.client.core.edm.EdmAnnotationImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class EdmAnnotationsImpl
implements EdmAnnotations {
    private final Edm edm;
    private final EdmSchema schema;
    private final Annotations annotationGroup;
    private EdmAnnotationsTarget target;
    private List<EdmAnnotation> annotations;

    public EdmAnnotationsImpl(Edm edm, EdmSchema schema, Annotations annotationGroup) {
        this.edm = edm;
        this.schema = schema;
        this.annotationGroup = annotationGroup;
    }

    private EdmAnnotationsTarget getTarget(EdmStructuredType structured, String path) {
        EdmAnnotationsTarget _target = null;
        if (structured != null && (_target = (EdmAnnotationsTarget)(path == null ? structured : structured.getStructuralProperty(path))) == null) {
            _target = structured.getNavigationProperty(path);
        }
        return _target;
    }

    private EdmAnnotationsTarget getTarget(EdmEnumType enumType, String path) {
        EdmEnumType _target = null;
        if (enumType != null) {
            _target = path == null ? enumType : enumType.getMember(path);
        }
        return _target;
    }

    public EdmAnnotationsTarget getTarget() {
        if (this.target == null) {
            String[] splitted = StringUtils.split((String)this.annotationGroup.getTarget(), (char)'/');
            FullQualifiedName base = new FullQualifiedName(splitted[0]);
            String path = splitted.length > 1 ? splitted[1] : null;
            EdmEntityContainer baseEntityContainer = this.schema.getEntityContainer(base);
            EdmActionImport edmActionImport = this.target = baseEntityContainer == null ? null : baseEntityContainer.getActionImport(path);
            if (this.target == null) {
                this.target = this.getTarget((EdmStructuredType)this.edm.getComplexType(base), path);
                if (this.target == null) {
                    this.target = baseEntityContainer;
                    if (this.target == null) {
                        EdmEntitySet edmEntitySet = this.target = baseEntityContainer == null ? null : baseEntityContainer.getEntitySet(path);
                        if (this.target == null) {
                            this.target = this.getTarget((EdmStructuredType)this.edm.getEntityType(base), path);
                            if (this.target == null) {
                                this.target = this.getTarget(this.edm.getEnumType(base), path);
                                if (this.target == null) {
                                    EdmFunctionImport edmFunctionImport = this.target = baseEntityContainer == null ? null : baseEntityContainer.getFunctionImport(path);
                                    if (this.target == null) {
                                        EdmSingleton edmSingleton = this.target = baseEntityContainer == null ? null : baseEntityContainer.getSingleton(path);
                                        if (this.target == null) {
                                            this.target = this.edm.getTerm(base);
                                            if (this.target == null) {
                                                this.target = this.edm.getTypeDefinition(base);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.target;
    }

    public String getQualifier() {
        return this.annotationGroup.getQualifier();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        EdmAnnotation result = null;
        for (EdmAnnotation annotation : this.getAnnotations()) {
            if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
            result = annotation;
        }
        return result;
    }

    public List<EdmAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
            for (Annotation annotation : this.annotationGroup.getAnnotations()) {
                this.annotations.add(new EdmAnnotationImpl(this.edm, annotation));
            }
        }
        return this.annotations;
    }
}

