/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.ComplexType;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.client.core.edm.EdmStructuredTypeHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmComplexType;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmStructuredTypeHelper;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmComplexTypeImpl
extends AbstractEdmComplexType {
    private final EdmStructuredTypeHelper typeHelper;
    private EdmAnnotationHelper annotationHelper;

    public static EdmComplexTypeImpl getInstance(Edm edm, FullQualifiedName fqn, List<? extends Schema> xmlSchemas, org.apache.olingo.client.api.edm.xml.ComplexType complexType) {
        FullQualifiedName baseTypeName = null;
        if (complexType instanceof ComplexType) {
            String baseType = ((ComplexType)complexType).getBaseType();
            baseTypeName = baseType == null ? null : new EdmTypeInfo.Builder().setTypeExpression(baseType).build().getFullQualifiedName();
        }
        EdmComplexTypeImpl instance = new EdmComplexTypeImpl(edm, fqn, baseTypeName, xmlSchemas, complexType);
        instance.baseType = instance.buildBaseType(baseTypeName);
        return instance;
    }

    private EdmComplexTypeImpl(Edm edm, FullQualifiedName fqn, FullQualifiedName baseTypeName, List<? extends Schema> xmlSchemas, org.apache.olingo.client.api.edm.xml.ComplexType complexType) {
        super(edm, fqn, baseTypeName);
        this.typeHelper = new EdmStructuredTypeHelperImpl(edm, this.getFullQualifiedName(), xmlSchemas, complexType);
        if (complexType instanceof ComplexType) {
            this.annotationHelper = new EdmAnnotationHelperImpl(edm, (Annotatable)((ComplexType)complexType));
        }
    }

    protected Map<String, EdmProperty> getProperties() {
        return this.typeHelper.getProperties();
    }

    protected Map<String, EdmNavigationProperty> getNavigationProperties() {
        return this.typeHelper.getNavigationProperties();
    }

    public boolean isOpenType() {
        return this.typeHelper.isOpenType();
    }

    public boolean isAbstract() {
        return this.typeHelper.isAbstract();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.annotationHelper == null ? null : this.annotationHelper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.annotationHelper == null ? null : this.annotationHelper.getAnnotations();
    }
}

