/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.CommonFunctionImport;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v3.FunctionImport;
import org.apache.olingo.client.api.edm.xml.v4.ActionImport;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.EntityContainer;
import org.apache.olingo.client.api.edm.xml.v4.EntitySet;
import org.apache.olingo.client.api.edm.xml.v4.Singleton;
import org.apache.olingo.client.api.v3.UnsupportedInV3Exception;
import org.apache.olingo.client.core.edm.EdmActionImportImpl;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.client.core.edm.EdmEntitySetImpl;
import org.apache.olingo.client.core.edm.EdmFunctionImportImpl;
import org.apache.olingo.client.core.edm.EdmSingletonImpl;
import org.apache.olingo.client.core.edm.v3.EdmActionImportProxy;
import org.apache.olingo.client.core.edm.v3.EdmEntitySetProxy;
import org.apache.olingo.client.core.edm.v3.EdmFunctionImportProxy;
import org.apache.olingo.client.core.edm.v3.FunctionImportUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmEntityContainer;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmEntityContainerImpl
extends AbstractEdmEntityContainer {
    private final org.apache.olingo.client.api.edm.xml.EntityContainer xmlEntityContainer;
    private final List<? extends Schema> xmlSchemas;
    private EdmAnnotationHelper helper;

    public EdmEntityContainerImpl(Edm edm, FullQualifiedName entityContainerName, org.apache.olingo.client.api.edm.xml.EntityContainer xmlEntityContainer, List<? extends Schema> xmlSchemas) {
        super(edm, entityContainerName, xmlEntityContainer.getExtends() == null ? null : new FullQualifiedName(xmlEntityContainer.getExtends()));
        this.xmlEntityContainer = xmlEntityContainer;
        this.xmlSchemas = xmlSchemas;
        if (xmlEntityContainer instanceof EntityContainer) {
            this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)((EntityContainer)xmlEntityContainer));
        }
    }

    public boolean isDefault() {
        return this.xmlEntityContainer instanceof EntityContainer ? true : this.xmlEntityContainer.isDefaultEntityContainer();
    }

    protected EdmSingleton createSingleton(String singletonName) {
        if (!(this.xmlEntityContainer instanceof EntityContainer)) {
            throw new UnsupportedInV3Exception();
        }
        Singleton singleton = ((EntityContainer)this.xmlEntityContainer).getSingleton(singletonName);
        return singleton == null ? null : new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, singletonName, new EdmTypeInfo.Builder().setTypeExpression(singleton.getEntityType()).setDefaultNamespace(this.entityContainerName.getNamespace()).build().getFullQualifiedName(), singleton);
    }

    protected EdmEntitySet createEntitySet(String entitySetName) {
        Object result = null;
        org.apache.olingo.client.api.edm.xml.EntitySet entitySet = this.xmlEntityContainer.getEntitySet(entitySetName);
        if (entitySet != null) {
            FullQualifiedName entityType = new EdmTypeInfo.Builder().setTypeExpression(entitySet.getEntityType()).setDefaultNamespace(this.entityContainerName.getNamespace()).build().getFullQualifiedName();
            result = entitySet instanceof EntitySet ? new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, entitySetName, entityType, (EntitySet)entitySet) : new EdmEntitySetProxy(this.edm, (EdmEntityContainer)this, entitySetName, entityType, this.xmlSchemas);
        }
        return result;
    }

    protected EdmActionImport createActionImport(String actionImportName) {
        EdmActionImportImpl result = null;
        if (this.xmlEntityContainer instanceof EntityContainer) {
            ActionImport actionImport = ((EntityContainer)this.xmlEntityContainer).getActionImport(actionImportName);
            if (actionImport != null) {
                result = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, actionImportName, actionImport);
            }
        } else {
            FunctionImport functionImport = (FunctionImport)this.xmlEntityContainer.getFunctionImport(actionImportName);
            if (functionImport != null) {
                result = new EdmActionImportProxy(this.edm, (EdmEntityContainer)this, actionImportName, functionImport);
            }
        }
        return result;
    }

    protected EdmFunctionImport createFunctionImport(String functionImportName) {
        Object result = null;
        CommonFunctionImport functionImport = this.xmlEntityContainer.getFunctionImport(functionImportName);
        if (functionImport != null) {
            result = functionImport instanceof org.apache.olingo.client.api.edm.xml.v4.FunctionImport ? new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, functionImportName, (org.apache.olingo.client.api.edm.xml.v4.FunctionImport)functionImport) : new EdmFunctionImportProxy(this.edm, (EdmEntityContainer)this, functionImportName, (FunctionImport)functionImport);
        }
        return result;
    }

    protected void loadAllEntitySets() {
        List localEntitySets = this.xmlEntityContainer.getEntitySets();
        if (localEntitySets != null) {
            for (org.apache.olingo.client.api.edm.xml.EntitySet entitySet : localEntitySets) {
                FullQualifiedName entityType = new EdmTypeInfo.Builder().setTypeExpression(entitySet.getEntityType()).setDefaultNamespace(this.entityContainerName.getNamespace()).build().getFullQualifiedName();
                Object edmSet = entitySet instanceof EntitySet ? new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, entitySet.getName(), entityType, (EntitySet)entitySet) : new EdmEntitySetProxy(this.edm, (EdmEntityContainer)this, entitySet.getName(), entityType, this.xmlSchemas);
                this.entitySets.put(edmSet.getName(), edmSet);
            }
        }
    }

    protected void loadAllFunctionImports() {
        List localFunctionImports = this.xmlEntityContainer.getFunctionImports();
        for (CommonFunctionImport functionImport : localFunctionImports) {
            EdmFunctionImportImpl edmFunctionImport;
            if (functionImport instanceof org.apache.olingo.client.api.edm.xml.v4.FunctionImport) {
                edmFunctionImport = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, functionImport.getName(), (org.apache.olingo.client.api.edm.xml.v4.FunctionImport)functionImport);
                this.functionImports.put(edmFunctionImport.getName(), edmFunctionImport);
                continue;
            }
            if (!FunctionImportUtils.canProxyFunction((FunctionImport)((FunctionImport)functionImport)) || ((FunctionImport)functionImport).isBindable() || ((FunctionImport)functionImport).isAlwaysBindable()) continue;
            edmFunctionImport = new EdmFunctionImportProxy(this.edm, (EdmEntityContainer)this, functionImport.getName(), (FunctionImport)functionImport);
            this.functionImports.put(edmFunctionImport.getName(), edmFunctionImport);
        }
    }

    protected void loadAllSingletons() {
        if (!(this.xmlEntityContainer instanceof EntityContainer)) {
            throw new UnsupportedInV3Exception();
        }
        List localSingletons = ((EntityContainer)this.xmlEntityContainer).getSingletons();
        if (localSingletons != null) {
            for (Singleton singleton : localSingletons) {
                this.singletons.put(singleton.getName(), new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, singleton.getName(), new EdmTypeInfo.Builder().setTypeExpression(singleton.getEntityType()).setDefaultNamespace(this.entityContainerName.getNamespace()).build().getFullQualifiedName(), singleton));
            }
        }
    }

    protected void loadAllActionImports() {
        block3: {
            block2: {
                if (!(this.xmlEntityContainer instanceof EntityContainer)) break block2;
                List localActionImports = ((EntityContainer)this.xmlEntityContainer).getActionImports();
                if (this.actionImports == null) break block3;
                for (ActionImport actionImport : localActionImports) {
                    this.actionImports.put(actionImport.getName(), new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, actionImport.getName(), actionImport));
                }
                break block3;
            }
            List localFunctionImports = this.xmlEntityContainer.getFunctionImports();
            for (FunctionImport functionImport : localFunctionImports) {
                if (FunctionImportUtils.canProxyFunction((FunctionImport)functionImport) || functionImport.isBindable() || functionImport.isAlwaysBindable()) continue;
                this.actionImports.put(functionImport.getName(), new EdmActionImportProxy(this.edm, (EdmEntityContainer)this, functionImport.getName(), functionImport));
            }
        }
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.EntityContainer;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper == null ? null : this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper == null ? Collections.emptyList() : this.helper.getAnnotations();
    }
}

