/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Term;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmNamedImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmTermImpl
extends EdmNamedImpl
implements EdmTerm {
    private static final Logger LOG = LoggerFactory.getLogger(EdmTermImpl.class);
    private final Term term;
    private final FullQualifiedName fqn;
    private final EdmTypeInfo typeInfo;
    private final EdmAnnotationHelper helper;
    private EdmType termType;
    private EdmTerm baseTerm;
    private List<Class<?>> appliesTo;

    public EdmTermImpl(Edm edm, String namespace, Term term) {
        super(edm, term.getName());
        this.term = term;
        this.fqn = new FullQualifiedName(namespace, term.getName());
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(term.getType()).build();
        this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)term);
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.fqn;
    }

    public EdmType getType() {
        if (this.termType == null) {
            Object object = this.typeInfo.isPrimitiveType() ? EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)this.typeInfo.getPrimitiveTypeKind()) : (this.typeInfo.isTypeDefinition() ? this.typeInfo.getTypeDefinition() : (this.typeInfo.isEnumType() ? this.typeInfo.getEnumType() : (this.termType = this.typeInfo.isComplexType() ? this.typeInfo.getComplexType() : null)));
            if (this.termType == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
        }
        return this.termType;
    }

    public EdmTerm getBaseTerm() {
        if (this.baseTerm == null && this.term.getBaseTerm() != null) {
            this.baseTerm = this.edm.getTerm(new FullQualifiedName(this.term.getBaseTerm()));
        }
        return this.baseTerm;
    }

    public List<Class<?>> getAppliesTo() {
        if (this.appliesTo == null) {
            this.appliesTo = new ArrayList();
            for (String element : this.term.getAppliesTo()) {
                try {
                    this.appliesTo.add(ClassUtils.getClass((String)(EdmTerm.class.getPackage().getName() + ".Edm" + element)));
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Could not load Edm class for {}", (Object)element, (Object)e);
                }
            }
        }
        return this.appliesTo;
    }

    public Boolean isNullable() {
        return this.term.isNullable();
    }

    public Integer getMaxLength() {
        return this.term.getMaxLength();
    }

    public Integer getPrecision() {
        return this.term.getPrecision();
    }

    public Integer getScale() {
        return this.term.getScale();
    }

    public SRID getSrid() {
        return this.term.getSrid();
    }

    public String getDefaultValue() {
        return this.term.getDefaultValue();
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.Term;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper.getAnnotations();
    }
}

