/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.List;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.TypeDefinition;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.AbstractEdmTypeDefinition;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmTypeDefinitionImpl
extends AbstractEdmTypeDefinition {
    private final TypeDefinition typeDefinition;
    private final EdmPrimitiveType edmPrimitiveTypeInstance;
    private final EdmAnnotationHelper helper;

    public EdmTypeDefinitionImpl(ODataServiceVersion version, Edm edm, FullQualifiedName typeDefinitionName, TypeDefinition typeDefinition) {
        super(edm, typeDefinitionName);
        this.typeDefinition = typeDefinition;
        try {
            this.edmPrimitiveTypeInstance = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOfFQN((ODataServiceVersion)version, (String)typeDefinition.getUnderlyingType()));
        }
        catch (IllegalArgumentException e) {
            throw new EdmException("Invalid underlying type: " + typeDefinition.getUnderlyingType(), (Exception)e);
        }
        this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)typeDefinition);
    }

    public EdmPrimitiveType getUnderlyingType() {
        return this.edmPrimitiveTypeInstance;
    }

    public Integer getMaxLength() {
        return this.typeDefinition.getMaxLength();
    }

    public Integer getPrecision() {
        return this.typeDefinition.getPrecision();
    }

    public Integer getScale() {
        return this.typeDefinition.getScale();
    }

    public SRID getSrid() {
        return this.typeDefinition.getSrid();
    }

    public Boolean isUnicode() {
        return this.typeDefinition.isUnicode();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper.getAnnotations();
    }
}

