/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.v3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.PropertyRef;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v3.Association;
import org.apache.olingo.client.api.edm.xml.v3.AssociationEnd;
import org.apache.olingo.client.api.edm.xml.v3.NavigationProperty;
import org.apache.olingo.client.api.edm.xml.v3.ReferentialConstraint;
import org.apache.olingo.client.core.edm.EdmReferentialConstraintImpl;
import org.apache.olingo.client.core.edm.xml.v3.SchemaImpl;
import org.apache.olingo.client.core.edm.xml.v4.ReferentialConstraintImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmNavigationProperty;

public class EdmNavigationPropertyProxy
extends AbstractEdmNavigationProperty {
    private final NavigationProperty navigationProperty;
    private final FullQualifiedName typeFQN;
    private final boolean isCollection;
    private final boolean isNullable;
    private EdmNavigationProperty partner;
    private final ReferentialConstraint constraint;
    private List<EdmReferentialConstraint> referentialConstraints;

    /*
     * WARNING - void declaration
     */
    public EdmNavigationPropertyProxy(Edm edm, List<? extends Schema> xmlSchemas, NavigationProperty navigationProperty) {
        super(edm, navigationProperty.getName());
        void var7_9;
        this.navigationProperty = navigationProperty;
        FullQualifiedName relFQN = new FullQualifiedName(navigationProperty.getRelationship());
        Schema associationSchema = null;
        for (Schema schema : xmlSchemas) {
            if (!schema.getNamespace().equals(relFQN.getNamespace())) continue;
            associationSchema = schema;
        }
        if (!(associationSchema instanceof SchemaImpl)) {
            throw new IllegalArgumentException("Could not find schema for Association " + relFQN);
        }
        Association association = ((SchemaImpl)associationSchema).getAssociation(relFQN.getName());
        if (association == null) {
            throw new IllegalArgumentException("Could not find Association " + relFQN.getName());
        }
        Object var7_8 = null;
        AssociationEnd partnerEnd = null;
        for (AssociationEnd _end : association.getEnds()) {
            if (_end.getRole().equals(navigationProperty.getToRole())) {
                AssociationEnd associationEnd = _end;
                continue;
            }
            partnerEnd = _end;
        }
        if (var7_9 == null || partnerEnd == null) {
            throw new IllegalArgumentException("Could not find AssociationEnd for role " + navigationProperty.getToRole());
        }
        this.typeFQN = new FullQualifiedName(var7_9.getType());
        this.isCollection = "*".equals(var7_9.getMultiplicity());
        this.isNullable = var7_9.getMultiplicity().charAt(0) == '0';
        this.constraint = association.getReferentialConstraint();
        EdmEntityType partnerEntity = edm.getEntityType(new FullQualifiedName(var7_9.getType()));
        for (String navPropName : partnerEntity.getNavigationPropertyNames()) {
            EdmNavigationPropertyProxy navProp = (EdmNavigationPropertyProxy)partnerEntity.getNavigationProperty(navPropName);
            if (!partnerEnd.getRole().equals(navProp.getXMLNavigationProperty().getToRole())) continue;
            this.partner = navProp;
        }
    }

    protected NavigationProperty getXMLNavigationProperty() {
        return this.navigationProperty;
    }

    protected FullQualifiedName getTypeFQN() {
        return this.typeFQN;
    }

    protected String internatGetPartner() {
        return null;
    }

    public EdmNavigationProperty getPartner() {
        return this.partner == null ? this : this.partner;
    }

    public String getReferencingPropertyName(String referencedPropertyName) {
        if (this.constraint != null) {
            for (int i = 0; i < this.constraint.getPrincipal().getPropertyRefs().size(); ++i) {
                if (!referencedPropertyName.equals(((PropertyRef)this.constraint.getPrincipal().getPropertyRefs().get(i)).getName())) continue;
                return ((PropertyRef)this.constraint.getDependent().getPropertyRefs().get(i)).getName();
            }
        }
        return null;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Boolean isNullable() {
        return this.isNullable;
    }

    public Boolean containsTarget() {
        return this.navigationProperty.isContainsTarget();
    }

    public List<EdmReferentialConstraint> getReferentialConstraints() {
        if (this.referentialConstraints == null) {
            this.referentialConstraints = new ArrayList();
            if (this.constraint != null) {
                for (int i = 0; i < this.constraint.getPrincipal().getPropertyRefs().size(); ++i) {
                    ReferentialConstraintImpl referentialConstraint = new ReferentialConstraintImpl();
                    referentialConstraint.setProperty(((PropertyRef)this.constraint.getPrincipal().getPropertyRefs().get(i)).getName());
                    referentialConstraint.setReferencedProperty(((PropertyRef)this.constraint.getDependent().getPropertyRefs().get(i)).getName());
                    this.referentialConstraints.add(new EdmReferentialConstraintImpl(this.edm, (org.apache.olingo.client.api.edm.xml.v4.ReferentialConstraint)referentialConstraint));
                }
            }
        }
        return this.referentialConstraints;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return null;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return null;
    }

    public List<EdmAnnotation> getAnnotations() {
        return Collections.emptyList();
    }
}

