/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.v4;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v4.ActionImport;
import org.apache.olingo.client.api.edm.xml.v4.EntityContainer;
import org.apache.olingo.client.api.edm.xml.v4.FunctionImport;
import org.apache.olingo.client.api.edm.xml.v4.Singleton;
import org.apache.olingo.client.core.edm.AbstractEdmServiceMetadataImpl;
import org.apache.olingo.commons.api.edm.EdmActionImportInfo;
import org.apache.olingo.commons.api.edm.EdmFunctionImportInfo;
import org.apache.olingo.commons.api.edm.EdmSingletonInfo;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.EdmActionImportInfoImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImportInfoImpl;
import org.apache.olingo.commons.core.edm.EdmSingletonInfoImpl;

public class EdmServiceMetadataImpl
extends AbstractEdmServiceMetadataImpl {
    private static final ODataServiceVersion SERVICE_VERSION = ODataServiceVersion.V40;
    private List<EdmSingletonInfo> singletonInfos;

    public EdmServiceMetadataImpl(List<Schema> xmlSchemas) {
        super(xmlSchemas);
    }

    public ODataServiceVersion getDataServiceVersion() {
        return SERVICE_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EdmSingletonInfo> getSingletonInfos() {
        EdmServiceMetadataImpl edmServiceMetadataImpl = this;
        synchronized (edmServiceMetadataImpl) {
            if (this.singletonInfos == null) {
                this.singletonInfos = new ArrayList();
                for (Schema schema : this.xmlSchemas) {
                    EntityContainer entityContainer = (EntityContainer)schema.getDefaultEntityContainer();
                    for (Singleton singleton : entityContainer.getSingletons()) {
                        this.singletonInfos.add(new EdmSingletonInfoImpl(entityContainer.getName(), singleton.getName()));
                    }
                }
            }
            return this.singletonInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EdmFunctionImportInfo> getFunctionImportInfos() {
        EdmServiceMetadataImpl edmServiceMetadataImpl = this;
        synchronized (edmServiceMetadataImpl) {
            if (this.functionImportInfos == null) {
                this.functionImportInfos = new ArrayList();
                for (Schema schema : this.xmlSchemas) {
                    EntityContainer entityContainer = (EntityContainer)schema.getDefaultEntityContainer();
                    for (FunctionImport functionImport : entityContainer.getFunctionImports()) {
                        this.functionImportInfos.add(new EdmFunctionImportInfoImpl(entityContainer.getName(), functionImport.getName()));
                    }
                }
            }
        }
        return this.functionImportInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EdmActionImportInfo> getActionImportInfos() {
        EdmServiceMetadataImpl edmServiceMetadataImpl = this;
        synchronized (edmServiceMetadataImpl) {
            if (this.actionImportInfos == null) {
                this.actionImportInfos = new ArrayList();
                for (Schema schema : this.xmlSchemas) {
                    EntityContainer entityContainer = (EntityContainer)schema.getDefaultEntityContainer();
                    for (ActionImport actionImport : entityContainer.getActionImports()) {
                        this.actionImportInfos.add(new EdmActionImportInfoImpl(entityContainer.getName(), actionImport.getName()));
                    }
                }
            }
            return this.actionImportInfos;
        }
    }
}

