/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.EntityKey;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.AbstractEntityType;
import org.apache.olingo.client.core.edm.xml.EntityKeyImpl;
import org.apache.olingo.client.core.edm.xml.v3.EntityTypeImpl;
import org.apache.olingo.client.core.edm.xml.v3.NavigationPropertyImpl;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.PropertyImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class EntityTypeDeserializer
extends AbstractEdmDeserializer<AbstractEntityType> {
    protected AbstractEntityType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EntityTypeImpl entityType;
        Object object = entityType = ODataServiceVersion.V30 == this.version ? new EntityTypeImpl() : new org.apache.olingo.client.core.edm.xml.v4.EntityTypeImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    entityType.setName(jp.nextTextValue());
                } else if ("Abstract".equals(jp.getCurrentName())) {
                    entityType.setAbstractEntityType(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("BaseType".equals(jp.getCurrentName())) {
                    entityType.setBaseType(jp.nextTextValue());
                } else if ("OpenType".equals(jp.getCurrentName())) {
                    entityType.setOpenType(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("HasStream".equals(jp.getCurrentName())) {
                    entityType.setHasStream(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Key".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    entityType.setKey((EntityKey)jp.readValueAs(EntityKeyImpl.class));
                } else if ("Property".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    if (entityType instanceof EntityTypeImpl) {
                        entityType.getProperties().add(jp.readValueAs(org.apache.olingo.client.core.edm.xml.v3.PropertyImpl.class));
                    } else {
                        ((org.apache.olingo.client.core.edm.xml.v4.EntityTypeImpl)entityType).getProperties().add(jp.readValueAs(PropertyImpl.class));
                    }
                } else if ("NavigationProperty".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    if (entityType instanceof EntityTypeImpl) {
                        entityType.getNavigationProperties().add(jp.readValueAs(NavigationPropertyImpl.class));
                    } else {
                        ((org.apache.olingo.client.core.edm.xml.v4.EntityTypeImpl)entityType).getNavigationProperties().add(jp.readValueAs(org.apache.olingo.client.core.edm.xml.v4.NavigationPropertyImpl.class));
                    }
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((org.apache.olingo.client.core.edm.xml.v4.EntityTypeImpl)entityType).getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return entityType;
    }
}

