/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.ConcurrencyMode;
import org.apache.olingo.client.api.edm.StoreGeneratedPattern;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.AbstractProperty;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.PropertyImpl;
import org.apache.olingo.commons.api.edm.constants.EdmContentKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class PropertyDeserializer
extends AbstractEdmDeserializer<AbstractProperty> {
    protected AbstractProperty doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        org.apache.olingo.client.core.edm.xml.v3.PropertyImpl property;
        Object object = property = ODataServiceVersion.V30 == this.version ? new org.apache.olingo.client.core.edm.xml.v3.PropertyImpl() : new PropertyImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    property.setName(jp.nextTextValue());
                } else if ("Type".equals(jp.getCurrentName())) {
                    property.setType(jp.nextTextValue());
                } else if ("Nullable".equals(jp.getCurrentName())) {
                    property.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("DefaultValue".equals(jp.getCurrentName())) {
                    property.setDefaultValue(jp.nextTextValue());
                } else if ("MaxLength".equals(jp.getCurrentName())) {
                    String maxLenght = jp.nextTextValue();
                    property.setMaxLength(Integer.valueOf(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght)));
                } else if ("FixedLength".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFixedLength(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    }
                } else if ("Precision".equals(jp.getCurrentName())) {
                    property.setPrecision(Integer.valueOf(jp.nextTextValue()));
                } else if ("Scale".equals(jp.getCurrentName())) {
                    String scale = jp.nextTextValue();
                    property.setScale(Integer.valueOf(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale)));
                } else if ("Unicode".equals(jp.getCurrentName())) {
                    property.setUnicode(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Collation".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setCollation(jp.nextTextValue());
                    }
                } else if ("SRID".equals(jp.getCurrentName())) {
                    String srid = jp.nextTextValue();
                    if (srid != null) {
                        property.setSrid(SRID.valueOf((String)srid));
                    }
                } else if ("ConcurrencyMode".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setConcurrencyMode(ConcurrencyMode.valueOf((String)jp.nextTextValue()));
                    }
                } else if ("StoreGeneratedPattern".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setStoreGeneratedPattern(StoreGeneratedPattern.valueOf((String)jp.nextTextValue()));
                    }
                } else if ("FC_SourcePath".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFcSourcePath(jp.nextTextValue());
                    }
                } else if ("FC_TargetPath".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFcTargetPath(jp.nextTextValue());
                    }
                } else if ("FC_ContentKind".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFcContentKind(EdmContentKind.valueOf((String)jp.nextTextValue()));
                    }
                } else if ("FC_NsPrefix".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFcNSPrefix(jp.nextTextValue());
                    }
                } else if ("FC_NsUri".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFcNSURI(jp.nextTextValue());
                    }
                } else if ("FC_KeepInContent".equals(jp.getCurrentName())) {
                    if (property instanceof org.apache.olingo.client.core.edm.xml.v3.PropertyImpl) {
                        property.setFcKeepInContent(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    }
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((PropertyImpl)property).getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return property;
    }
}

