/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.FunctionImportImpl;

public class FunctionImportDeserializer
extends AbstractEdmDeserializer<FunctionImportImpl> {
    protected FunctionImportImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FunctionImportImpl functImpImpl = new FunctionImportImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    functImpImpl.setName(jp.nextTextValue());
                } else if ("Function".equals(jp.getCurrentName())) {
                    functImpImpl.setFunction(jp.nextTextValue());
                } else if ("EntitySet".equals(jp.getCurrentName())) {
                    functImpImpl.setEntitySet(jp.nextTextValue());
                } else if ("IncludeInServiceDocument".equals(jp.getCurrentName())) {
                    functImpImpl.setIncludeInServiceDocument(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    functImpImpl.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return functImpImpl;
    }
}

