/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.edm.xml.EnumType;
import org.apache.olingo.client.api.edm.xml.v4.Action;
import org.apache.olingo.client.api.edm.xml.v4.ActionImport;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Annotations;
import org.apache.olingo.client.api.edm.xml.v4.ComplexType;
import org.apache.olingo.client.api.edm.xml.v4.EntityContainer;
import org.apache.olingo.client.api.edm.xml.v4.EntitySet;
import org.apache.olingo.client.api.edm.xml.v4.EntityType;
import org.apache.olingo.client.api.edm.xml.v4.Function;
import org.apache.olingo.client.api.edm.xml.v4.FunctionImport;
import org.apache.olingo.client.api.edm.xml.v4.Schema;
import org.apache.olingo.client.api.edm.xml.v4.Singleton;
import org.apache.olingo.client.api.edm.xml.v4.Term;
import org.apache.olingo.client.api.edm.xml.v4.TypeDefinition;
import org.apache.olingo.client.core.edm.xml.AbstractSchema;
import org.apache.olingo.client.core.edm.xml.v4.EntityContainerImpl;
import org.apache.olingo.client.core.edm.xml.v4.EnumTypeImpl;

public class SchemaImpl
extends AbstractSchema
implements Schema {
    private static final long serialVersionUID = 1911087363912024939L;
    private final List<Action> actions = new ArrayList();
    private final List<Annotations> annotationGroups = new ArrayList();
    private final List<Annotation> annotations = new ArrayList();
    private final List<ComplexType> complexTypes = new ArrayList();
    private EntityContainer entityContainer;
    private final List<EnumType> enumTypes = new ArrayList();
    private final List<EntityType> entityTypes = new ArrayList();
    private final List<Function> functions = new ArrayList();
    private final List<Term> terms = new ArrayList();
    private final List<TypeDefinition> typeDefinitions = new ArrayList();
    private Map<String, Annotatable> annotatables;

    public List<Action> getActions() {
        return this.actions;
    }

    public List<Action> getActions(String name) {
        return this.getAllByName(name, (Collection)this.getActions());
    }

    public List<Annotations> getAnnotationGroups() {
        return this.annotationGroups;
    }

    public Annotations getAnnotationGroup(String target) {
        Annotations result = null;
        for (Annotations annots : this.getAnnotationGroups()) {
            if (!target.equals(annots.getTarget())) continue;
            result = annots;
        }
        return result;
    }

    public Annotation getAnnotation(String term) {
        Annotation result = null;
        for (Annotation annot : this.getAnnotations()) {
            if (!term.equals(annot.getTerm())) continue;
            result = annot;
        }
        return result;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public List<Function> getFunctions(String name) {
        return this.getAllByName(name, (Collection)this.getFunctions());
    }

    public Term getTerm(String name) {
        return (Term)this.getOneByName(name, (Collection)this.getTerms());
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public TypeDefinition getTypeDefinition(String name) {
        return (TypeDefinition)this.getOneByName(name, (Collection)this.getTypeDefinitions());
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public EntityContainer getEntityContainer() {
        return this.entityContainer;
    }

    public void setEntityContainer(EntityContainerImpl entityContainer) {
        this.entityContainer = entityContainer;
    }

    public List<EntityContainer> getEntityContainers() {
        return this.entityContainer == null ? Collections.emptyList() : Collections.singletonList(this.entityContainer);
    }

    public EntityContainer getDefaultEntityContainer() {
        return this.entityContainer;
    }

    public EntityContainer getEntityContainer(String name) {
        if (this.entityContainer != null && name.equals(this.entityContainer.getName())) {
            return this.entityContainer;
        }
        return null;
    }

    public List<EnumType> getEnumTypes() {
        return this.enumTypes;
    }

    public ComplexType getComplexType(String name) {
        return (ComplexType)super.getComplexType(name);
    }

    public List<ComplexType> getComplexTypes() {
        return this.complexTypes;
    }

    public EntityType getEntityType(String name) {
        return (EntityType)super.getEntityType(name);
    }

    public List<EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public Map<String, Annotatable> getAnnotatables() {
        if (this.annotatables == null) {
            this.annotatables = new HashMap();
            for (Annotations annotationGroup : this.getAnnotationGroups()) {
                this.annotatables.put(null, annotationGroup);
            }
            for (Annotation annotation : this.getAnnotations()) {
                this.annotatables.put(annotation.getTerm(), annotation);
            }
            for (Action action : this.getActions()) {
                this.annotatables.put(action.getName(), action);
            }
            for (ComplexType complexType : this.getComplexTypes()) {
                this.annotatables.put(complexType.getName(), complexType);
            }
            for (EntityType entityType : this.getEntityTypes()) {
                this.annotatables.put(entityType.getName(), entityType);
            }
            for (EnumType enumType : this.getEnumTypes()) {
                this.annotatables.put(enumType.getName(), (EnumTypeImpl)enumType);
            }
            for (Function function : this.getFunctions()) {
                this.annotatables.put(function.getName(), function);
            }
            for (Term term : this.getTerms()) {
                this.annotatables.put(term.getName(), term);
            }
            for (TypeDefinition typedef : this.getTypeDefinitions()) {
                this.annotatables.put(typedef.getName(), typedef);
            }
            if (this.entityContainer != null) {
                this.annotatables.put(this.entityContainer.getName(), this.entityContainer);
                for (Annotation annotation : this.entityContainer.getAnnotations()) {
                    this.annotatables.put(annotation.getTerm(), annotation);
                }
                for (ActionImport actionImport : this.entityContainer.getActionImports()) {
                    this.annotatables.put(actionImport.getName(), actionImport);
                }
                for (FunctionImport functionImport : this.entityContainer.getFunctionImports()) {
                    this.annotatables.put(functionImport.getName(), functionImport);
                }
                for (EntitySet entitySet : this.entityContainer.getEntitySets()) {
                    this.annotatables.put(entitySet.getName(), entitySet);
                }
                for (Singleton singleton : this.entityContainer.getSingletons()) {
                    this.annotatables.put(singleton.getName(), singleton);
                }
            }
        }
        return this.annotatables;
    }
}

