/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization.v3;

import java.net.URI;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.domain.v3.ODataLinkCollection;
import org.apache.olingo.client.api.serialization.v3.ODataBinder;
import org.apache.olingo.client.core.serialization.AbstractODataBinder;
import org.apache.olingo.client.core.v3.ODataClientImpl;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.data.v3.LinkCollection;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.domain.v3.ODataEntity;
import org.apache.olingo.commons.api.domain.v3.ODataEntitySet;
import org.apache.olingo.commons.api.domain.v3.ODataProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.domain.v3.ODataPropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.ContextURLParser;

public class ODataBinderImpl
extends AbstractODataBinder
implements ODataBinder {
    public ODataBinderImpl(ODataClientImpl client) {
        super((CommonODataClient)client);
    }

    public boolean add(CommonODataEntity entity, CommonODataProperty property) {
        return ((ODataEntity)entity).getProperties().add((ODataProperty)property);
    }

    protected boolean add(CommonODataEntitySet entitySet, CommonODataEntity entity) {
        return ((ODataEntitySet)entitySet).getEntities().add((ODataEntity)entity);
    }

    public Property getProperty(CommonODataProperty property) {
        PropertyImpl propertyResource = new PropertyImpl();
        propertyResource.setName(property.getName());
        Object propertyValue = this.getValue(property.getValue());
        if (property.hasPrimitiveValue()) {
            propertyResource.setType(property.getPrimitiveValue().getTypeName());
            propertyResource.setValue(propertyValue instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, propertyValue);
        } else if (property.hasComplexValue()) {
            propertyResource.setType(((ODataProperty)property).getComplexValue().getTypeName());
            propertyResource.setValue(ValueType.COMPLEX, propertyValue);
        } else if (property.hasCollectionValue()) {
            ODataCollectionValue collectionValue = ((ODataProperty)property).getCollectionValue();
            propertyResource.setType(collectionValue.getTypeName());
            ODataValue value = collectionValue.iterator().hasNext() ? (ODataValue)collectionValue.iterator().next() : null;
            ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
            if (value == null) {
                valueType = ValueType.COLLECTION_PRIMITIVE;
            } else if (value.isPrimitive()) {
                valueType = value.asPrimitive().toValue() instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
            } else if (value.isComplex()) {
                valueType = ValueType.COLLECTION_COMPLEX;
            }
            propertyResource.setValue(valueType, propertyValue);
        }
        return propertyResource;
    }

    public ODataEntitySet getODataEntitySet(ResWrap<EntitySet> resource) {
        return (ODataEntitySet)super.getODataEntitySet(resource);
    }

    public ODataEntity getODataEntity(ResWrap<Entity> resource) {
        return (ODataEntity)super.getODataEntity(resource);
    }

    public ODataProperty getODataProperty(ResWrap<Property> property) {
        EdmTypeInfo typeInfo = this.buildTypeInfo(ContextURLParser.parse((URI)property.getContextURL()), property.getMetadataETag(), ((Property)property.getPayload()).getName(), ((Property)property.getPayload()).getType());
        return new ODataPropertyImpl(((Property)property.getPayload()).getName(), this.getODataValue(typeInfo == null ? null : typeInfo.getFullQualifiedName(), (Valuable)property.getPayload(), property.getContextURL(), property.getMetadataETag()));
    }

    protected ODataProperty getODataProperty(EdmType type, Property resource) {
        EdmTypeInfo typeInfo = this.buildTypeInfo(type == null ? null : type.getFullQualifiedName(), resource.getType());
        return new ODataPropertyImpl(resource.getName(), this.getODataValue(typeInfo == null ? null : typeInfo.getFullQualifiedName(), (Valuable)resource, null, null));
    }

    public ODataLinkCollection getLinkCollection(LinkCollection linkCollection) {
        ODataLinkCollection collection = new ODataLinkCollection(linkCollection.getNext());
        collection.setLinks(linkCollection.getLinks());
        return collection;
    }
}

