/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization.v4;

import java.net.URI;
import java.util.List;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.data.ServiceDocumentItem;
import org.apache.olingo.client.api.serialization.v4.ODataBinder;
import org.apache.olingo.client.api.v4.EdmEnabledODataClient;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.serialization.AbstractODataBinder;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataInlineEntity;
import org.apache.olingo.commons.api.domain.ODataInlineEntitySet;
import org.apache.olingo.commons.api.domain.ODataLinked;
import org.apache.olingo.commons.api.domain.ODataServiceDocument;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotatable;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.domain.v4.ODataDeletedEntity;
import org.apache.olingo.commons.api.domain.v4.ODataDelta;
import org.apache.olingo.commons.api.domain.v4.ODataEntity;
import org.apache.olingo.commons.api.domain.v4.ODataEntitySet;
import org.apache.olingo.commons.api.domain.v4.ODataLink;
import org.apache.olingo.commons.api.domain.v4.ODataLinkedComplexValue;
import org.apache.olingo.commons.api.domain.v4.ODataProperty;
import org.apache.olingo.commons.api.domain.v4.ODataValuable;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.core.data.AnnotationImpl;
import org.apache.olingo.commons.core.data.LinkedComplexValueImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.domain.v4.ODataAnnotationImpl;
import org.apache.olingo.commons.core.domain.v4.ODataDeletedEntityImpl;
import org.apache.olingo.commons.core.domain.v4.ODataDeltaLinkImpl;
import org.apache.olingo.commons.core.domain.v4.ODataPropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.ContextURLParser;

public class ODataBinderImpl
extends AbstractODataBinder
implements ODataBinder {
    public ODataBinderImpl(ODataClient client) {
        super((CommonODataClient)client);
    }

    public boolean add(CommonODataEntity entity, CommonODataProperty property) {
        return ((ODataEntity)entity).getProperties().add((ODataProperty)property);
    }

    protected boolean add(CommonODataEntitySet entitySet, CommonODataEntity entity) {
        return ((ODataEntitySet)entitySet).getEntities().add((ODataEntity)entity);
    }

    public ODataServiceDocument getODataServiceDocument(ServiceDocument resource) {
        ODataServiceDocument serviceDocument = super.getODataServiceDocument(resource);
        for (ServiceDocumentItem functionImport : resource.getFunctionImports()) {
            serviceDocument.getFunctionImports().put(functionImport.getName() == null ? functionImport.getUrl() : functionImport.getName(), URIUtils.getURI((URI)resource.getBaseURI(), (String)functionImport.getUrl()));
        }
        for (ServiceDocumentItem singleton : resource.getSingletons()) {
            serviceDocument.getSingletons().put(singleton.getName() == null ? singleton.getUrl() : singleton.getName(), URIUtils.getURI((URI)resource.getBaseURI(), (String)singleton.getUrl()));
        }
        for (ServiceDocumentItem sdoc : resource.getRelatedServiceDocuments()) {
            serviceDocument.getRelatedServiceDocuments().put(sdoc.getName() == null ? sdoc.getUrl() : sdoc.getName(), URIUtils.getURI((URI)resource.getBaseURI(), (String)sdoc.getUrl()));
        }
        return serviceDocument;
    }

    private void updateValuable(Valuable propertyResource, ODataValuable odataValuable) {
        Object propertyValue = this.getValue((ODataValue)odataValuable.getValue());
        if (odataValuable.hasPrimitiveValue()) {
            propertyResource.setType(odataValuable.getPrimitiveValue().getTypeName());
            propertyResource.setValue(propertyValue instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, propertyValue);
        } else if (odataValuable.hasEnumValue()) {
            propertyResource.setType(odataValuable.getEnumValue().getTypeName());
            propertyResource.setValue(ValueType.ENUM, propertyValue);
        } else if (odataValuable.hasComplexValue()) {
            propertyResource.setType(odataValuable.getComplexValue().getTypeName());
            propertyResource.setValue(propertyValue instanceof LinkedComplexValue ? ValueType.LINKED_COMPLEX : ValueType.COMPLEX, propertyValue);
        } else if (odataValuable.hasCollectionValue()) {
            ODataCollectionValue collectionValue = odataValuable.getCollectionValue();
            propertyResource.setType(collectionValue.getTypeName());
            org.apache.olingo.commons.api.domain.v4.ODataValue value = collectionValue.iterator().hasNext() ? (org.apache.olingo.commons.api.domain.v4.ODataValue)collectionValue.iterator().next() : null;
            ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
            if (value == null) {
                valueType = ValueType.COLLECTION_PRIMITIVE;
            } else if (value.isPrimitive()) {
                valueType = value.asPrimitive().toValue() instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
            } else if (value.isEnum()) {
                valueType = ValueType.COLLECTION_ENUM;
            } else if (value.isLinkedComplex()) {
                valueType = ValueType.COLLECTION_LINKED_COMPLEX;
            } else if (value.isComplex()) {
                valueType = ValueType.COLLECTION_COMPLEX;
            }
            propertyResource.setValue(valueType, propertyValue);
        }
    }

    private void annotations(ODataAnnotatable odataAnnotatable, Annotatable annotatable) {
        for (ODataAnnotation odataAnnotation : odataAnnotatable.getAnnotations()) {
            AnnotationImpl annotation = new AnnotationImpl();
            annotation.setTerm(odataAnnotation.getTerm());
            annotation.setType(odataAnnotation.getValue().getTypeName());
            this.updateValuable((Valuable)annotation, (ODataValuable)odataAnnotation);
            annotatable.getAnnotations().add(annotation);
        }
    }

    public EntitySet getEntitySet(CommonODataEntitySet odataEntitySet) {
        EntitySet entitySet = super.getEntitySet(odataEntitySet);
        entitySet.setDeltaLink(((ODataEntitySet)odataEntitySet).getDeltaLink());
        this.annotations((ODataAnnotatable)((ODataEntitySet)odataEntitySet), (Annotatable)entitySet);
        return entitySet;
    }

    protected void links(ODataLinked odataLinked, Linked linked) {
        super.links(odataLinked, linked);
        for (Link link : linked.getNavigationLinks()) {
            org.apache.olingo.commons.api.domain.ODataLink odataLink = odataLinked.getNavigationLink(link.getTitle());
            if (odataLink instanceof ODataInlineEntity || odataLink instanceof ODataInlineEntitySet) continue;
            this.annotations((ODataAnnotatable)((ODataLink)odataLink), (Annotatable)link);
        }
    }

    public Entity getEntity(CommonODataEntity odataEntity) {
        Entity entity = super.getEntity(odataEntity);
        entity.setId(((ODataEntity)odataEntity).getId());
        this.annotations((ODataAnnotatable)((ODataEntity)odataEntity), (Annotatable)entity);
        return entity;
    }

    public Property getProperty(CommonODataProperty property) {
        ODataProperty _property = (ODataProperty)property;
        PropertyImpl propertyResource = new PropertyImpl();
        propertyResource.setName(_property.getName());
        this.updateValuable((Valuable)propertyResource, (ODataValuable)_property);
        this.annotations((ODataAnnotatable)_property, (Annotatable)propertyResource);
        return propertyResource;
    }

    protected Object getValue(ODataValue value) {
        Object valueResource;
        if (value instanceof org.apache.olingo.commons.api.domain.v4.ODataValue && ((org.apache.olingo.commons.api.domain.v4.ODataValue)value).isEnum()) {
            valueResource = ((org.apache.olingo.commons.api.domain.v4.ODataValue)value).asEnum().getValue();
        } else {
            valueResource = super.getValue(value);
            if (value instanceof org.apache.olingo.commons.api.domain.v4.ODataValue && ((org.apache.olingo.commons.api.domain.v4.ODataValue)value).isLinkedComplex()) {
                LinkedComplexValueImpl lcValueResource = new LinkedComplexValueImpl();
                lcValueResource.getValue().addAll((List)valueResource);
                ODataLinkedComplexValue linked = ((org.apache.olingo.commons.api.domain.v4.ODataValue)value).asLinkedComplex();
                this.annotations((ODataAnnotatable)linked, (Annotatable)lcValueResource);
                this.links((ODataLinked)linked, (Linked)lcValueResource);
                valueResource = lcValueResource;
            }
        }
        return valueResource;
    }

    private void odataAnnotations(Annotatable annotatable, ODataAnnotatable odataAnnotatable) {
        for (Annotation annotation : annotatable.getAnnotations()) {
            EdmTypeInfo typeInfo;
            EdmTerm term;
            FullQualifiedName fqn = null;
            if (this.client instanceof EdmEnabledODataClient && (term = ((EdmEnabledODataClient)this.client).getCachedEdm().getTerm(new FullQualifiedName(annotation.getTerm()))) != null) {
                fqn = term.getType().getFullQualifiedName();
            }
            if (fqn == null && annotation.getType() != null && (typeInfo = new EdmTypeInfo.Builder().setTypeExpression(annotation.getType()).build()).isPrimitiveType()) {
                fqn = typeInfo.getPrimitiveTypeKind().getFullQualifiedName();
            }
            ODataAnnotationImpl odataAnnotation = new ODataAnnotationImpl(annotation.getTerm(), (org.apache.olingo.commons.api.domain.v4.ODataValue)this.getODataValue(fqn, (Valuable)annotation, null, null));
            odataAnnotatable.getAnnotations().add(odataAnnotation);
        }
    }

    public ODataEntitySet getODataEntitySet(ResWrap<EntitySet> resource) {
        ODataEntitySet entitySet = (ODataEntitySet)super.getODataEntitySet(resource);
        if (((EntitySet)resource.getPayload()).getDeltaLink() != null) {
            URI base = resource.getContextURL() == null ? ((EntitySet)resource.getPayload()).getBaseURI() : ContextURLParser.parse((URI)resource.getContextURL()).getServiceRoot();
            entitySet.setDeltaLink(URIUtils.getURI((URI)base, (URI)((EntitySet)resource.getPayload()).getDeltaLink()));
        }
        this.odataAnnotations((Annotatable)resource.getPayload(), (ODataAnnotatable)entitySet);
        return entitySet;
    }

    protected void odataNavigationLinks(EdmType edmType, Linked linked, ODataLinked odataLinked, String metadataETag, URI base) {
        super.odataNavigationLinks(edmType, linked, odataLinked, metadataETag, base);
        for (org.apache.olingo.commons.api.domain.ODataLink link : odataLinked.getNavigationLinks()) {
            if (link instanceof ODataInlineEntity || link instanceof ODataInlineEntitySet) continue;
            this.odataAnnotations((Annotatable)linked.getNavigationLink(link.getName()), (ODataAnnotatable)link);
        }
    }

    public ODataEntity getODataEntity(ResWrap<Entity> resource) {
        ODataEntity entity = (ODataEntity)super.getODataEntity(resource);
        entity.setId(((Entity)resource.getPayload()).getId());
        this.odataAnnotations((Annotatable)resource.getPayload(), (ODataAnnotatable)entity);
        return entity;
    }

    public ODataProperty getODataProperty(ResWrap<Property> resource) {
        Property payload = (Property)resource.getPayload();
        EdmTypeInfo typeInfo = this.buildTypeInfo(ContextURLParser.parse((URI)resource.getContextURL()), resource.getMetadataETag(), payload.getName(), payload.getType());
        ODataPropertyImpl property = new ODataPropertyImpl(payload.getName(), this.getODataValue(typeInfo == null ? null : typeInfo.getFullQualifiedName(), (Valuable)payload, resource.getContextURL(), resource.getMetadataETag()));
        this.odataAnnotations((Annotatable)payload, (ODataAnnotatable)property);
        return property;
    }

    protected ODataProperty getODataProperty(EdmType type, Property resource) {
        EdmTypeInfo typeInfo = this.buildTypeInfo(type == null ? null : type.getFullQualifiedName(), resource.getType());
        ODataPropertyImpl property = new ODataPropertyImpl(resource.getName(), this.getODataValue(typeInfo == null ? null : typeInfo.getFullQualifiedName(), (Valuable)resource, null, null));
        this.odataAnnotations((Annotatable)resource, (ODataAnnotatable)property);
        return property;
    }

    protected ODataValue getODataValue(FullQualifiedName type, Valuable valuable, URI contextURL, String metadataETag) {
        ODataValue value;
        if (this.client instanceof EdmEnabledODataClient && type != null) {
            EdmEnumType edmType = ((EdmEnabledODataClient)this.client).getEdm(metadataETag).getEnumType(type);
            if (valuable.isPrimitive() && edmType != null) {
                valuable.setValue(ValueType.ENUM, valuable.asPrimitive());
            }
        }
        if (valuable.isEnum()) {
            value = ((ODataClient)this.client).getObjectFactory().newEnumValue(type == null ? null : type.toString(), valuable.asEnum().toString());
        } else if (valuable.isLinkedComplex()) {
            ODataLinkedComplexValue lcValue = ((ODataClient)this.client).getObjectFactory().newLinkedComplexValue(type == null ? null : type.toString());
            EdmComplexType edmType = null;
            if (this.client instanceof EdmEnabledODataClient && type != null) {
                edmType = ((EdmEnabledODataClient)this.client).getEdm(metadataETag).getComplexType(type);
            }
            for (Property property : valuable.asLinkedComplex().getValue()) {
                EdmElement edmProp;
                EdmType edmPropertyType = null;
                if (edmType != null && (edmProp = edmType.getProperty(property.getName())) != null) {
                    edmPropertyType = edmProp.getType();
                }
                lcValue.add((CommonODataProperty)this.getODataProperty(edmPropertyType, property));
            }
            this.odataNavigationLinks((EdmType)edmType, (Linked)valuable.asLinkedComplex(), (ODataLinked)lcValue, metadataETag, contextURL);
            this.odataAnnotations((Annotatable)valuable.asLinkedComplex(), (ODataAnnotatable)lcValue);
            value = lcValue;
        } else {
            value = super.getODataValue(type, valuable, contextURL, metadataETag);
        }
        return value;
    }

    public ODataDelta getODataDelta(ResWrap<Delta> resource) {
        ODataDeletedEntityImpl impl;
        ODataDelta delta;
        URI base = resource.getContextURL() == null ? ((Delta)resource.getPayload()).getBaseURI() : ContextURLParser.parse((URI)resource.getContextURL()).getServiceRoot();
        URI next = ((Delta)resource.getPayload()).getNext();
        ODataDelta oDataDelta = delta = next == null ? ((ODataClient)this.client).getObjectFactory().newDelta() : ((ODataClient)this.client).getObjectFactory().newDelta(URIUtils.getURI((URI)base, (String)next.toASCIIString()));
        if (((Delta)resource.getPayload()).getCount() != null) {
            delta.setCount(((Delta)resource.getPayload()).getCount().intValue());
        }
        if (((Delta)resource.getPayload()).getDeltaLink() != null) {
            delta.setDeltaLink(URIUtils.getURI((URI)base, (URI)((Delta)resource.getPayload()).getDeltaLink()));
        }
        for (Entity entityResource : ((Delta)resource.getPayload()).getEntities()) {
            this.add((CommonODataEntitySet)delta, (CommonODataEntity)this.getODataEntity(new ResWrap(resource.getContextURL(), resource.getMetadataETag(), (Object)entityResource)));
        }
        for (DeletedEntity deletedEntity : ((Delta)resource.getPayload()).getDeletedEntities()) {
            impl = new ODataDeletedEntityImpl();
            impl.setId(URIUtils.getURI((URI)base, (URI)deletedEntity.getId()));
            impl.setReason(ODataDeletedEntity.Reason.valueOf((String)deletedEntity.getReason().name()));
            delta.getDeletedEntities().add(impl);
        }
        this.odataAnnotations((Annotatable)resource.getPayload(), (ODataAnnotatable)delta);
        for (DeltaLink link : ((Delta)resource.getPayload()).getAddedLinks()) {
            impl = new ODataDeltaLinkImpl();
            impl.setRelationship(link.getRelationship());
            impl.setSource(URIUtils.getURI((URI)base, (URI)link.getSource()));
            impl.setTarget(URIUtils.getURI((URI)base, (URI)link.getTarget()));
            this.odataAnnotations((Annotatable)link, (ODataAnnotatable)impl);
            delta.getAddedLinks().add(impl);
        }
        for (DeltaLink link : ((Delta)resource.getPayload()).getDeletedLinks()) {
            impl = new ODataDeltaLinkImpl();
            impl.setRelationship(link.getRelationship());
            impl.setSource(URIUtils.getURI((URI)base, (URI)link.getSource()));
            impl.setTarget(URIUtils.getURI((URI)base, (URI)link.getTarget()));
            this.odataAnnotations((Annotatable)link, (ODataAnnotatable)impl);
            delta.getDeletedLinks().add(impl);
        }
        return delta;
    }
}

