/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import org.apache.olingo.client.api.uri.CommonFilterArgFactory;
import org.apache.olingo.client.api.uri.FilterArg;
import org.apache.olingo.client.core.uri.FilterConst;
import org.apache.olingo.client.core.uri.FilterFunction;
import org.apache.olingo.client.core.uri.FilterLiteral;
import org.apache.olingo.client.core.uri.FilterOp;
import org.apache.olingo.client.core.uri.FilterProperty;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public abstract class AbstractFilterArgFactory
implements CommonFilterArgFactory {
    private final ODataServiceVersion version;

    public AbstractFilterArgFactory(ODataServiceVersion version) {
        this.version = version;
    }

    public FilterArg _null() {
        return new FilterConst("null");
    }

    public FilterArg property(String propertyPath) {
        return new FilterProperty(propertyPath);
    }

    public FilterArg literal(Object value) {
        return new FilterLiteral(this.version, value);
    }

    public FilterArg add(FilterArg first, FilterArg second) {
        return new FilterOp("add", first, second);
    }

    public FilterArg sub(FilterArg first, FilterArg second) {
        return new FilterOp("add", first, second);
    }

    public FilterArg mul(FilterArg first, FilterArg second) {
        return new FilterOp("mul", first, second);
    }

    public FilterArg div(FilterArg first, FilterArg second) {
        return new FilterOp("div", first, second);
    }

    public FilterArg mod(FilterArg first, FilterArg second) {
        return new FilterOp("mod", first, second);
    }

    public FilterArg endswith(FilterArg first, FilterArg second) {
        return new FilterFunction("endswith", new FilterArg[]{first, second});
    }

    public FilterArg startswith(FilterArg first, FilterArg second) {
        return new FilterFunction("startswith", new FilterArg[]{first, second});
    }

    public FilterArg length(FilterArg param) {
        return new FilterFunction("length", new FilterArg[]{param});
    }

    public FilterArg indexof(FilterArg first, FilterArg second) {
        return new FilterFunction("indexof", new FilterArg[]{first, second});
    }

    public FilterArg replace(FilterArg first, FilterArg second, FilterArg third) {
        return new FilterFunction("replace", new FilterArg[]{first, second, third});
    }

    public FilterArg substring(FilterArg arg, FilterArg pos) {
        return new FilterFunction("substring", new FilterArg[]{arg, pos});
    }

    public FilterArg substring(FilterArg arg, FilterArg pos, FilterArg length) {
        return new FilterFunction("substring", new FilterArg[]{arg, pos, length});
    }

    public FilterArg tolower(FilterArg param) {
        return new FilterFunction("tolower", new FilterArg[]{param});
    }

    public FilterArg toupper(FilterArg param) {
        return new FilterFunction("toupper", new FilterArg[]{param});
    }

    public FilterArg trim(FilterArg param) {
        return new FilterFunction("trim", new FilterArg[]{param});
    }

    public FilterArg concat(FilterArg first, FilterArg second) {
        return new FilterFunction("concat", new FilterArg[]{first, second});
    }

    public FilterArg day(FilterArg param) {
        return new FilterFunction("day", new FilterArg[]{param});
    }

    public FilterArg hour(FilterArg param) {
        return new FilterFunction("hour", new FilterArg[]{param});
    }

    public FilterArg minute(FilterArg param) {
        return new FilterFunction("minute", new FilterArg[]{param});
    }

    public FilterArg month(FilterArg param) {
        return new FilterFunction("month", new FilterArg[]{param});
    }

    public FilterArg second(FilterArg param) {
        return new FilterFunction("second", new FilterArg[]{param});
    }

    public FilterArg year(FilterArg param) {
        return new FilterFunction("year", new FilterArg[]{param});
    }

    public FilterArg round(FilterArg param) {
        return new FilterFunction("round", new FilterArg[]{param});
    }

    public FilterArg floor(FilterArg param) {
        return new FilterFunction("floor", new FilterArg[]{param});
    }

    public FilterArg ceiling(FilterArg param) {
        return new FilterFunction("ceiling", new FilterArg[]{param});
    }

    public FilterArg isof(FilterArg type) {
        return new FilterFunction("isof", new FilterArg[]{type});
    }

    public FilterArg isof(FilterArg expression, FilterArg type) {
        return new FilterFunction("isof", new FilterArg[]{expression, type});
    }
}

