/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FullQualifiedName {
    private final String namespace;
    private final String name;
    private final String fqn;

    public FullQualifiedName(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.fqn = namespace + "." + name;
    }

    public FullQualifiedName(String namespaceAndName) {
        int dotIdx = namespaceAndName.lastIndexOf(46);
        if (dotIdx == -1 || dotIdx == 0 || dotIdx == namespaceAndName.length() - 1) {
            throw new IllegalArgumentException("Malformed " + FullQualifiedName.class.getSimpleName() + ": " + namespaceAndName);
        }
        this.fqn = namespaceAndName;
        this.namespace = this.fqn.substring(0, dotIdx);
        this.name = this.fqn.substring(dotIdx + 1);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getFullQualifiedNameAsString() {
        return this.fqn;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return this.fqn;
    }
}

