/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.SRID;

public abstract class Geospatial
implements Serializable {
    private static final long serialVersionUID = 5409612902190067390L;
    protected final Dimension dimension;
    protected final Type type;
    protected final SRID srid;

    protected Geospatial(Dimension dimension, Type type, SRID srid) {
        this.dimension = dimension;
        this.type = type;
        this.srid = srid == null ? new SRID() : srid;
        this.srid.setDimension(dimension);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Type getType() {
        return this.type;
    }

    public SRID getSrid() {
        return this.srid;
    }

    public abstract EdmPrimitiveTypeKind getEdmPrimitiveTypeKind();

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

