/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import java.util.List;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.ComposedGeospatial;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class Polygon
extends Geospatial {
    private static final long serialVersionUID = 7797602503445391678L;
    final ComposedGeospatial<Point> interior;
    final ComposedGeospatial<Point> exterior;

    public Polygon(Geospatial.Dimension dimension, SRID srid, List<Point> interior, List<Point> exterior) {
        super(dimension, Geospatial.Type.POLYGON, srid);
        this.interior = new MultiPoint(dimension, srid, interior);
        this.exterior = new MultiPoint(dimension, srid, exterior);
    }

    public ComposedGeospatial<Point> getInterior() {
        return this.interior;
    }

    public ComposedGeospatial<Point> getExterior() {
        return this.exterior;
    }

    public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind() {
        return this.dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPolygon : EdmPrimitiveTypeKind.GeometryPolygon;
    }
}

