/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.TypeUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AcceptType {
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private final Float quality;

    private AcceptType(String type, String subtype, Map<String, String> parameters, Float quality) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = AcceptType.createParameterMap();
        this.parameters.putAll(parameters);
        this.quality = quality;
    }

    private static TreeMap<String, String> createParameterMap() {
        return new TreeMap<String, String>((Comparator<String>)new /* Unavailable Anonymous Inner Class!! */);
    }

    private AcceptType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Type parameter MUST NOT be null.");
        }
        ArrayList typeSubtype = new ArrayList();
        this.parameters = AcceptType.createParameterMap();
        AcceptType.parse((String)type, typeSubtype, (Map)this.parameters);
        this.type = (String)typeSubtype.get(0);
        this.subtype = (String)typeSubtype.get(1);
        if ("*".equals(this.type) && !"*".equals(this.subtype)) {
            throw new IllegalArgumentException("Illegal combination of WILDCARD type with NONE WILDCARD subtype.");
        }
        String q = (String)this.parameters.get("q");
        if (q == null) {
            this.quality = Float.valueOf(1.0f);
        } else {
            try {
                this.quality = Float.valueOf(q);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal quality parameter.", e);
            }
        }
    }

    private static void parse(String format, List<String> typeSubtype, Map<String, String> parameters) {
        String[] typesAndParameters = format.split(";", 2);
        String types = typesAndParameters[0];
        String params = typesAndParameters.length > 1 ? typesAndParameters[1] : null;
        String[] tokens = types.split("/");
        if (tokens.length == 1) {
            typeSubtype.add(tokens[0]);
            typeSubtype.add("*");
        } else if (tokens.length == 2) {
            if (tokens[0] == null || tokens[0].isEmpty()) {
                throw new IllegalArgumentException("No type found in format '" + format + "'.");
            }
            if (tokens[1] == null || tokens[1].isEmpty()) {
                throw new IllegalArgumentException("No subtype found in format '" + format + "'.");
            }
            typeSubtype.add(tokens[0]);
            typeSubtype.add(tokens[1]);
        } else {
            throw new IllegalArgumentException("Too many '/' in format '" + format + "'.");
        }
        TypeUtil.parseParameters((String)params, parameters);
    }

    public static List<AcceptType> create(String format) {
        String[] values;
        ArrayList<AcceptType> result = new ArrayList<AcceptType>();
        for (String value : values = format.split(",")) {
            result.add(new AcceptType(value.trim()));
        }
        AcceptType.sort(result);
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Float getQuality() {
        return this.quality;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type).append('/').append(this.subtype);
        for (String key : this.parameters.keySet()) {
            result.append(';').append(key).append('=').append((String)this.parameters.get(key));
        }
        return result.toString();
    }

    public boolean matches(ContentType contentType) {
        if (this.type.equals("*")) {
            return true;
        }
        if (!this.type.equalsIgnoreCase(contentType.getType())) {
            return false;
        }
        if (this.subtype.equals("*")) {
            return true;
        }
        if (!this.subtype.equalsIgnoreCase(contentType.getSubtype())) {
            return false;
        }
        Map compareParameters = contentType.getParameters();
        for (String key : this.parameters.keySet()) {
            if (compareParameters.containsKey(key) || "q".equalsIgnoreCase(key)) {
                if (((String)this.parameters.get(key)).equalsIgnoreCase((String)compareParameters.get(key)) || "q".equalsIgnoreCase(key)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static void sort(List<AcceptType> toSort) {
        Collections.sort(toSort, new /* Unavailable Anonymous Inner Class!! */);
    }
}

