/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.domain.AbstractODataPayload;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.domain.ODataOperation;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.domain.AbstractODataEntity;

public abstract class AbstractODataEntity
extends AbstractODataPayload
implements CommonODataEntity {
    private final FullQualifiedName typeName;
    private String eTag;
    private boolean mediaEntity = false;
    private String mediaContentType;
    private URI mediaContentSource;
    private String mediaETag;
    private URI editLink;
    private final List<ODataLink> navigationLinks = new ArrayList();
    private final List<ODataLink> associationLinks = new ArrayList();
    private final List<ODataLink> mediaEditLinks = new ArrayList();
    private final List<ODataOperation> operations = new ArrayList();

    public AbstractODataEntity(FullQualifiedName typeName) {
        super(typeName == null ? null : typeName.toString());
        this.typeName = typeName;
    }

    public FullQualifiedName getTypeName() {
        return this.typeName;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public ODataOperation getOperation(String title) {
        ODataOperation result = null;
        for (ODataOperation operation : this.operations) {
            if (!title.equals(operation.getTitle())) continue;
            result = operation;
        }
        return result;
    }

    public List<ODataOperation> getOperations() {
        return this.operations;
    }

    public CommonODataProperty getProperty(String name) {
        CommonODataProperty result = null;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (CommonODataProperty property : this.getProperties()) {
                if (!name.equals(property.getName())) continue;
                result = property;
            }
        }
        return result;
    }

    public boolean addLink(ODataLink link) {
        boolean result = false;
        switch (1.$SwitchMap$org$apache$olingo$commons$api$domain$ODataLinkType[link.getType().ordinal()]) {
            case 1: {
                result = this.associationLinks.contains(link) ? false : this.associationLinks.add(link);
                break;
            }
            case 2: 
            case 3: {
                result = this.navigationLinks.contains(link) ? false : this.navigationLinks.add(link);
                break;
            }
            case 4: {
                result = this.mediaEditLinks.contains(link) ? false : this.mediaEditLinks.add(link);
                break;
            }
        }
        return result;
    }

    public boolean removeLink(ODataLink link) {
        return this.associationLinks.remove(link) || this.navigationLinks.remove(link);
    }

    private ODataLink getLink(List<ODataLink> links, String name) {
        ODataLink result = null;
        for (ODataLink link : links) {
            if (!name.equals(link.getName())) continue;
            result = link;
        }
        return result;
    }

    public ODataLink getNavigationLink(String name) {
        return this.getLink(this.navigationLinks, name);
    }

    public List<ODataLink> getNavigationLinks() {
        return this.navigationLinks;
    }

    public ODataLink getAssociationLink(String name) {
        return this.getLink(this.associationLinks, name);
    }

    public List<ODataLink> getAssociationLinks() {
        return this.associationLinks;
    }

    public ODataLink getMediaEditLink(String name) {
        return this.getLink(this.mediaEditLinks, name);
    }

    public List<ODataLink> getMediaEditLinks() {
        return this.mediaEditLinks;
    }

    public URI getEditLink() {
        return this.editLink;
    }

    public void setEditLink(URI editLink) {
        this.editLink = editLink;
    }

    public URI getLink() {
        return super.getLink() == null ? this.getEditLink() : super.getLink();
    }

    public boolean isReadOnly() {
        return super.getLink() != null;
    }

    public boolean isMediaEntity() {
        return this.mediaEntity;
    }

    public void setMediaEntity(boolean isMediaEntity) {
        this.mediaEntity = isMediaEntity;
    }

    public String getMediaContentType() {
        return this.mediaContentType;
    }

    public void setMediaContentType(String mediaContentType) {
        this.mediaContentType = mediaContentType;
    }

    public URI getMediaContentSource() {
        return this.mediaContentSource;
    }

    public void setMediaContentSource(URI mediaContentSource) {
        this.mediaContentSource = mediaContentSource;
    }

    public String getMediaETag() {
        return this.mediaETag;
    }

    public void setMediaETag(String eTag) {
        this.mediaETag = eTag;
    }
}

