/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain;

import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.domain.AbstractODataValue;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;

public abstract class AbstractODataPrimitiveValue
extends AbstractODataValue
implements ODataPrimitiveValue {
    private EdmPrimitiveTypeKind typeKind;
    private EdmPrimitiveType type;
    private Object value;

    protected AbstractODataPrimitiveValue() {
        super(null);
    }

    public String getTypeName() {
        return this.typeKind.getFullQualifiedName().toString();
    }

    public EdmPrimitiveTypeKind getTypeKind() {
        return this.typeKind;
    }

    public EdmPrimitiveType getType() {
        return this.type;
    }

    public Object toValue() {
        return this.value;
    }

    public <T> T toCastValue(Class<T> reference) throws EdmPrimitiveTypeException {
        if (this.value == null) {
            return null;
        }
        if (this.typeKind.isGeospatial()) {
            return reference.cast(this.value);
        }
        return (T)this.type.valueOfString(this.type.valueToString(this.value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, reference);
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.typeKind.isGeospatial()) {
            return this.value.toString();
        }
        try {
            return this.type.valueToString(this.value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static /* synthetic */ EdmPrimitiveTypeKind access$002(AbstractODataPrimitiveValue x0, EdmPrimitiveTypeKind x1) {
        x0.typeKind = x1;
        return x0.typeKind;
    }

    static /* synthetic */ EdmPrimitiveType access$102(AbstractODataPrimitiveValue x0, EdmPrimitiveType x1) {
        x0.type = x1;
        return x0.type;
    }

    static /* synthetic */ EdmPrimitiveTypeKind access$000(AbstractODataPrimitiveValue x0) {
        return x0.typeKind;
    }

    static /* synthetic */ Object access$202(AbstractODataPrimitiveValue x0, Object x1) {
        x0.value = x1;
        return x0.value;
    }

    static /* synthetic */ EdmPrimitiveType access$100(AbstractODataPrimitiveValue x0) {
        return x0.type;
    }
}

