/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain.v4;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.domain.v4.ODataEnumValue;
import org.apache.olingo.commons.api.domain.v4.ODataLinkedComplexValue;
import org.apache.olingo.commons.api.domain.v4.ODataProperty;
import org.apache.olingo.commons.core.domain.AbstractODataComplexValue;
import org.apache.olingo.commons.core.domain.v4.ODataComplexValueImpl;

public class ODataComplexValueImpl
extends AbstractODataComplexValue<ODataProperty>
implements ODataLinkedComplexValue {
    private final List<ODataLink> navigationLinks = new ArrayList();
    private final List<ODataLink> associationLinks = new ArrayList();
    private final List<ODataAnnotation> annotations = new ArrayList();

    public ODataComplexValueImpl(String typeName) {
        super(typeName);
    }

    protected ODataComplexValue<ODataProperty> getThis() {
        return this;
    }

    public boolean isEnum() {
        return false;
    }

    public ODataEnumValue asEnum() {
        return null;
    }

    public boolean isLinkedComplex() {
        return true;
    }

    public ODataLinkedComplexValue asLinkedComplex() {
        return this;
    }

    public boolean addLink(ODataLink link) {
        boolean result = false;
        switch (1.$SwitchMap$org$apache$olingo$commons$api$domain$ODataLinkType[link.getType().ordinal()]) {
            case 1: {
                result = this.associationLinks.contains(link) ? false : this.associationLinks.add(link);
                break;
            }
            case 2: 
            case 3: {
                result = this.navigationLinks.contains(link) ? false : this.navigationLinks.add(link);
                break;
            }
            case 4: {
                throw new IllegalArgumentException("Complex values cannot have media links!");
            }
        }
        return result;
    }

    public boolean removeLink(ODataLink link) {
        return this.associationLinks.remove(link) || this.navigationLinks.remove(link);
    }

    private ODataLink getLink(List<ODataLink> links, String name) {
        ODataLink result = null;
        for (ODataLink link : links) {
            if (!name.equals(link.getName())) continue;
            result = link;
        }
        return result;
    }

    public ODataLink getNavigationLink(String name) {
        return this.getLink(this.navigationLinks, name);
    }

    public List<ODataLink> getNavigationLinks() {
        return this.navigationLinks;
    }

    public ODataLink getAssociationLink(String name) {
        return this.getLink(this.associationLinks, name);
    }

    public List<ODataLink> getAssociationLinks() {
        return this.associationLinks;
    }

    public Map<String, Object> asJavaMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : this.fields.entrySet()) {
            Object value = null;
            if (((ODataProperty)entry.getValue()).hasPrimitiveValue()) {
                value = ((ODataProperty)entry.getValue()).getPrimitiveValue().toValue();
            } else if (((ODataProperty)entry.getValue()).hasComplexValue()) {
                value = ((ODataProperty)entry.getValue()).getComplexValue().asJavaMap();
            } else if (((ODataProperty)entry.getValue()).hasCollectionValue()) {
                value = ((ODataProperty)entry.getValue()).getCollectionValue().asJavaCollection();
            } else if (((ODataProperty)entry.getValue()).hasEnumValue()) {
                value = ((ODataProperty)entry.getValue()).getEnumValue().toString();
            }
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    public List<ODataAnnotation> getAnnotations() {
        return this.annotations;
    }
}

