/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmTypeInfo {
    private final Edm edm;
    private final boolean collection;
    private final FullQualifiedName fullQualifiedName;
    private EdmPrimitiveTypeKind primitiveType;
    private EdmTypeDefinition typeDefinition;
    private EdmEnumType enumType;
    private EdmComplexType complexType;
    private EdmEntityType entityType;

    private EdmTypeInfo(Edm edm, String typeExpression) {
        String typeName;
        String namespace;
        String baseType;
        this.edm = edm;
        int collStartIdx = typeExpression.indexOf("Collection(");
        int collEndIdx = typeExpression.lastIndexOf(41);
        if (collStartIdx == -1) {
            baseType = typeExpression;
            this.collection = false;
        } else {
            if (collEndIdx == -1) {
                throw new IllegalArgumentException("Malformed type: " + typeExpression);
            }
            this.collection = true;
            baseType = typeExpression.substring(collStartIdx + 11, collEndIdx);
        }
        baseType = baseType.replaceAll("^#", "");
        int lastDotIdx = baseType.lastIndexOf(46);
        if (lastDotIdx == -1) {
            namespace = "Edm";
            typeName = baseType;
            baseType = new FullQualifiedName("Edm", baseType).toString();
        } else {
            namespace = baseType.substring(0, lastDotIdx);
            typeName = baseType.substring(lastDotIdx + 1);
        }
        if (StringUtils.isBlank((CharSequence)typeName)) {
            throw new IllegalArgumentException("Null or empty type name in " + typeExpression);
        }
        StringBuilder exp = new StringBuilder();
        exp.append(baseType);
        this.fullQualifiedName = new FullQualifiedName(namespace, typeName);
        try {
            this.primitiveType = EdmPrimitiveTypeKind.valueOf((String)this.fullQualifiedName.getName());
        }
        catch (IllegalArgumentException e) {
            this.primitiveType = null;
        }
        if (this.primitiveType == null && this.edm != null) {
            this.typeDefinition = this.edm.getTypeDefinition(this.fullQualifiedName);
            if (this.typeDefinition == null) {
                this.enumType = this.edm.getEnumType(this.fullQualifiedName);
                if (this.enumType == null) {
                    this.complexType = this.edm.getComplexType(this.fullQualifiedName);
                    if (this.complexType == null) {
                        this.entityType = this.edm.getEntityType(this.fullQualifiedName);
                    }
                }
            }
        }
    }

    public String internal() {
        StringBuilder deserialize = new StringBuilder();
        if (this.isCollection()) {
            deserialize.append("Collection(");
        }
        deserialize.append(this.getFullQualifiedName().toString());
        if (this.isCollection()) {
            deserialize.append(")");
        }
        return deserialize.toString();
    }

    public String external(ODataServiceVersion version) {
        StringBuilder serialize = new StringBuilder();
        if (this.isCollection()) {
            if (version.compareTo((Enum)ODataServiceVersion.V40) >= 0) {
                serialize.append('#');
            }
            serialize.append("Collection(");
        }
        if (this.isPrimitiveType() && version.compareTo((Enum)ODataServiceVersion.V40) >= 0) {
            serialize.append(this.getFullQualifiedName().getName());
        } else {
            serialize.append(this.getFullQualifiedName().toString());
        }
        if (this.isCollection()) {
            serialize.append(")");
        }
        if (version.compareTo((Enum)ODataServiceVersion.V40) >= 0 && !this.isPrimitiveType() && !this.isCollection()) {
            serialize.insert(0, '#');
        }
        return serialize.toString();
    }

    public boolean isCollection() {
        return this.collection;
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType != null;
    }

    public EdmPrimitiveTypeKind getPrimitiveTypeKind() {
        return this.primitiveType;
    }

    public boolean isTypeDefinition() {
        return this.typeDefinition != null;
    }

    public EdmTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isEnumType() {
        return this.enumType != null;
    }

    public EdmEnumType getEnumType() {
        return this.enumType;
    }

    public boolean isComplexType() {
        return this.complexType != null;
    }

    public EdmComplexType getComplexType() {
        return this.complexType;
    }

    public boolean isEntityType() {
        return this.entityType != null;
    }

    public EdmEntityType getEntityType() {
        return this.entityType;
    }

    public EdmType getType() {
        return this.isPrimitiveType() ? EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)this.getPrimitiveTypeKind()) : (this.isTypeDefinition() ? this.getTypeDefinition() : (this.isEnumType() ? this.getEnumType() : (this.isComplexType() ? this.getComplexType() : (this.isEntityType() ? this.getEntityType() : null))));
    }
}

