/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigInteger;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.commons.core.edm.primitivetype.Uint7;

public final class EdmByte
extends SingletonPrimitiveType {
    private static final EdmByte INSTANCE = new EdmByte();

    public static EdmByte getInstance() {
        return INSTANCE;
    }

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof Uint7 || primitiveType instanceof EdmByte;
    }

    public Class<?> getDefaultType() {
        return Short.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Short valueShort;
        try {
            valueShort = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)", (Exception)e);
        }
        if (valueShort < 0 || valueShort >= 256) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
        }
        try {
            return (T)EdmInt64.convertNumber((Number)valueShort, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType), e");
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType), e");
        }
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            if (((Number)value).longValue() >= 0L && ((Number)value).longValue() < 256L) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_ILLEGAL_CONTENT.addContent(value)");
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && ((BigInteger)value).compareTo(BigInteger.valueOf(256L)) < 0) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_ILLEGAL_CONTENT.addContent(value)");
        }
        throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass())");
    }
}

