/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EdmDateTimeOffset
extends SingletonPrimitiveType {
    public static final ThreadLocal<DecimalFormat> NANO_FORMAT = new /* Unavailable Anonymous Inner Class!! */;
    private static final Pattern PATTERN = Pattern.compile("(-?\\p{Digit}{4,})-(\\p{Digit}{2})-(\\p{Digit}{2})T(\\p{Digit}{2}):(\\p{Digit}{2})(?::(\\p{Digit}{2})(\\.(\\p{Digit}{0,12}?)0*)?)?(Z|([-+]\\p{Digit}{2}:\\p{Digit}{2}))?");
    private static final EdmDateTimeOffset INSTANCE = new EdmDateTimeOffset();

    public static EdmDateTimeOffset getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Timestamp.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
        }
        String timeZoneOffset = matcher.group(9) == null || matcher.group(10) == null || matcher.group(10).matches("[-+]0+:0+") ? null : matcher.group(10);
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT" + timeZoneOffset));
        if (dateTimeValue.get(15) == 0 && timeZoneOffset != null) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
        }
        dateTimeValue.clear();
        dateTimeValue.set(Short.parseShort(matcher.group(1)), Byte.parseByte(matcher.group(2)) - 1, Byte.parseByte(matcher.group(3)), Byte.parseByte(matcher.group(4)), Byte.parseByte(matcher.group(5)), matcher.group(6) == null ? 0 : (int)Byte.parseByte(matcher.group(6)));
        int nanoSeconds = 0;
        if (matcher.group(7) != null) {
            if (matcher.group(7).length() == 1 || matcher.group(7).length() > 13) {
                throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
            }
            String decimals = matcher.group(8);
            if (decimals.length() > (precision == null ? 0 : precision)) {
                throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(value, facets)");
            }
            if (returnType.isAssignableFrom(Timestamp.class)) {
                if (!decimals.isEmpty()) {
                    nanoSeconds = Integer.parseInt(decimals.length() > 9 ? decimals.substring(0, 9) : decimals + "000000000".substring(decimals.length()));
                }
            } else {
                String milliSeconds = decimals.length() > 3 ? decimals.substring(0, 3) : decimals + "000".substring(decimals.length());
                dateTimeValue.set(14, Short.parseShort(milliSeconds));
            }
        }
        try {
            return (T)EdmDateTimeOffset.convertDateTime((Calendar)dateTimeValue, (int)nanoSeconds, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType)", (Exception)e);
        }
    }

    protected static <T> T convertDateTime(Calendar dateTimeValue, int nanoSeconds, Class<T> returnType) throws IllegalArgumentException, ClassCastException {
        dateTimeValue.setLenient(false);
        if (returnType.isAssignableFrom(Calendar.class)) {
            dateTimeValue.get(14);
            dateTimeValue.setLenient(true);
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(dateTimeValue.getTimeInMillis());
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return returnType.cast(dateTimeValue.getTime());
        }
        if (returnType.isAssignableFrom(Timestamp.class)) {
            Timestamp timestamp = new Timestamp(dateTimeValue.getTimeInMillis());
            timestamp.setNanos(nanoSeconds);
            return returnType.cast(timestamp);
        }
        throw new ClassCastException("unsupported return type " + returnType.getSimpleName());
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        int fractionalSecs;
        Calendar dateTimeValue;
        if (value instanceof Timestamp) {
            Calendar tmp = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            tmp.setTimeInMillis(((Timestamp)value).getTime());
            dateTimeValue = EdmDateTimeOffset.createDateTime((Object)tmp);
            fractionalSecs = ((Timestamp)value).getNanos();
        } else {
            dateTimeValue = EdmDateTimeOffset.createDateTime(value);
            fractionalSecs = dateTimeValue.get(14);
        }
        StringBuilder result = new StringBuilder();
        int year = dateTimeValue.get(1);
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)(year / 100));
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)(year % 100));
        result.append('-');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)(dateTimeValue.get(2) + 1));
        result.append('-');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(5));
        result.append('T');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(11));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(12));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(13));
        try {
            if (value instanceof Timestamp) {
                EdmDateTimeOffset.appendFractionalSeconds((StringBuilder)result, (int)fractionalSecs, (Integer)precision);
            } else {
                EdmDateTimeOffset.appendMilliseconds((StringBuilder)result, (int)fractionalSecs, (Integer)precision);
            }
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets)", (Exception)e);
        }
        int offsetInMinutes = (dateTimeValue.get(15) + dateTimeValue.get(16)) / 60 / 1000;
        int offsetHours = offsetInMinutes / 60;
        int offsetMinutes = Math.abs(offsetInMinutes % 60);
        String offsetString = offsetInMinutes == 0 ? "Z" : String.format("%+03d:%02d", offsetHours, offsetMinutes);
        result.append(offsetString);
        return result.toString();
    }

    protected static <T> Calendar createDateTime(T value) throws EdmPrimitiveTypeException {
        Calendar dateTimeValue;
        if (value instanceof Date) {
            dateTimeValue = Calendar.getInstance();
            dateTimeValue.setTime((Date)value);
        } else if (value instanceof Calendar) {
            dateTimeValue = (Calendar)((Calendar)value).clone();
        } else if (value instanceof Long) {
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            dateTimeValue.setTimeInMillis((Long)value);
        } else {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(" + value.getClass().getName() + ")");
        }
        return dateTimeValue;
    }

    protected static void appendTwoDigits(StringBuilder result, int number) {
        result.append((char)(48 + number / 10));
        result.append((char)(48 + number % 10));
    }

    protected static void appendMilliseconds(StringBuilder result, int milliseconds, Integer precision) throws IllegalArgumentException {
        int digits;
        int n = milliseconds % 1000 == 0 ? 0 : (milliseconds % 100 == 0 ? 1 : (digits = milliseconds % 10 == 0 ? 2 : 3));
        if (digits > 0) {
            if (precision == null || precision < digits) {
                throw new IllegalArgumentException();
            }
            result.append('.');
            for (int d = 100; d > 0; d /= 10) {
                byte digit = (byte)(milliseconds % (d * 10) / d);
                if (digit <= 0 && milliseconds % d <= 0) continue;
                result.append((char)(48 + digit));
            }
        }
    }

    protected static void appendFractionalSeconds(StringBuilder result, int fractionalSeconds, Integer precision) throws IllegalArgumentException {
        if (fractionalSeconds > 0) {
            String formatted = ((DecimalFormat)NANO_FORMAT.get()).format(fractionalSeconds);
            int actualLength = formatted.length();
            boolean nonZeroFound = false;
            for (int i = formatted.length() - 1; i >= 0 && !nonZeroFound; --i) {
                if ('0' == formatted.charAt(i)) {
                    --actualLength;
                    continue;
                }
                nonZeroFound = true;
            }
            if (precision == null || precision < actualLength) {
                throw new IllegalArgumentException();
            }
            result.append('.').append(formatted.substring(0, actualLength));
        }
    }
}

