/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.net.URI;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmStream
extends SingletonPrimitiveType {
    private static final EdmStream INSTANCE = new EdmStream();

    public static EdmStream getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return URI.class;
    }

    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        if (value == null) {
            return isNullable == null || isNullable != false;
        }
        try {
            new URI(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        URI stream = null;
        try {
            stream = new URI(value);
        }
        catch (Exception e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)", e);
        }
        if (returnType.isAssignableFrom(URI.class)) {
            return returnType.cast(stream);
        }
        throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType)");
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof URI) {
            return ((URI)value).toASCIIString();
        }
        throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass())");
    }
}

