/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.ODataErrorDetail;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class JsonODataErrorDetailDeserializer
extends JsonDeserializer {
    public JsonODataErrorDetailDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<ODataErrorDetail> doDeserialize(JsonParser parser) throws IOException {
        ODataErrorDetail error = new ODataErrorDetail();
        JsonNode errorNode = (JsonNode)parser.getCodec().readTree(parser);
        if (errorNode.has("code")) {
            error.setCode(errorNode.get("code").textValue());
        }
        if (errorNode.has("message")) {
            JsonNode message = errorNode.get("message");
            if (message.isValueNode()) {
                error.setMessage(message.textValue());
            } else if (message.isObject()) {
                error.setMessage(message.get("value").asText());
            }
        }
        if (errorNode.has("target")) {
            error.setTarget(errorNode.get("target").textValue());
        }
        return new ResWrap((URI)null, null, (Object)error);
    }
}

