/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.olingo.client.api.CommonEdmEnabledODataClient;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.uri.v4.URIBuilder;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataInlineEntity;
import org.apache.olingo.commons.api.domain.ODataInlineEntitySet;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.domain.ODataLinked;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.ComplexCollection;
import org.apache.olingo.ext.proxy.api.EdmStreamValue;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.PrimitiveCollection;
import org.apache.olingo.ext.proxy.api.annotations.ComplexType;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.api.annotations.Property;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AnnotatableInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AnnotatationsInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EdmStreamValueHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.OperationInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PrimitiveCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityContext;
import org.apache.olingo.ext.proxy.context.EntityUUID;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CoreUtils;
import org.apache.olingo.ext.proxy.utils.ProxyUtils;

public abstract class AbstractStructuredInvocationHandler
extends AbstractInvocationHandler {
    private static final long serialVersionUID = 2629912294765040037L;
    protected CommonURIBuilder<?> uri;
    protected URI baseURI;
    protected final Class<?> typeRef;
    protected EntityInvocationHandler entityHandler;
    protected Object internal;
    private final Map<String, AnnotatableInvocationHandler> propAnnotatableHandlers = new HashMap();
    private final Map<String, AnnotatableInvocationHandler> navPropAnnotatableHandlers = new HashMap();
    protected final Map<String, Object> propertyChanges = new HashMap();
    protected final Map<String, Object> propertyCache = new HashMap();
    protected final Map<NavigationProperty, Object> linkChanges = new HashMap();
    protected final Map<NavigationProperty, Object> linkCache = new HashMap();
    protected int propertiesTag = 0;
    protected int linksTag = 0;
    protected final Map<String, EdmStreamValue> streamedPropertyChanges = new HashMap();
    protected final Map<String, EdmStreamValue> streamedPropertyCache = new HashMap();

    protected AbstractStructuredInvocationHandler(Class<?> typeRef, AbstractService<?> service) {
        super(service);
        this.internal = null;
        this.typeRef = typeRef;
        this.entityHandler = null;
    }

    protected AbstractStructuredInvocationHandler(Class<?> typeRef, Object internal, AbstractService<?> service) {
        super(service);
        this.internal = internal;
        this.typeRef = typeRef;
        this.entityHandler = null;
    }

    protected AbstractStructuredInvocationHandler(Class<?> typeRef, Object internal, EntityInvocationHandler entityHandler) {
        super(entityHandler == null ? null : entityHandler.service);
        this.internal = internal;
        this.typeRef = typeRef;
        this.entityHandler = entityHandler == this ? null : entityHandler;
    }

    public Object getInternal() {
        return this.internal;
    }

    public EntityInvocationHandler getEntityHandler() {
        return this.entityHandler == null ? (this instanceof EntityInvocationHandler ? (EntityInvocationHandler)EntityInvocationHandler.class.cast(this) : null) : this.entityHandler;
    }

    public void setEntityHandler(EntityInvocationHandler entityHandler) {
        this.entityHandler = entityHandler == this ? null : entityHandler;
    }

    public Class<?> getTypeRef() {
        return this.typeRef;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("expand".equals(method.getName()) || "select".equals(method.getName()) || "refs".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        if ("load".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            this.load();
            return proxy;
        }
        if ("loadAsync".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            return this.service.getClient().getConfiguration().getExecutor().submit(new /* Unavailable Anonymous Inner Class!! */);
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)OperationInvocationHandler.getInstance((EntityInvocationHandler)this.getEntityHandler()));
        }
        if ("annotations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)AnnotatationsInvocationHandler.getInstance((EntityInvocationHandler)this.getEntityHandler(), (AbstractStructuredInvocationHandler)this));
        }
        if (method.getName().startsWith("get")) {
            Object res;
            Method getter = this.typeRef.getMethod(method.getName(), new Class[0]);
            Property property = (Property)ClassUtils.getAnnotation(Property.class, (AccessibleObject)getter);
            if (property == null) {
                NavigationProperty navProp = (NavigationProperty)ClassUtils.getAnnotation(NavigationProperty.class, (AccessibleObject)getter);
                if (navProp == null) {
                    throw new UnsupportedOperationException("Unsupported method " + method.getName());
                }
                res = this.getNavigationPropertyValue(navProp, getter);
            } else {
                res = this.getPropertyValue(property.name(), getter.getGenericReturnType());
            }
            return res;
        }
        if (method.getName().startsWith("set")) {
            String getterName = method.getName().replaceFirst("set", "get");
            Method getter = this.typeRef.getMethod(getterName, new Class[0]);
            Property property = (Property)ClassUtils.getAnnotation(Property.class, (AccessibleObject)getter);
            if (property == null) {
                NavigationProperty navProp = (NavigationProperty)ClassUtils.getAnnotation(NavigationProperty.class, (AccessibleObject)getter);
                if (navProp == null) {
                    throw new UnsupportedOperationException("Unsupported method " + method.getName());
                }
                if (ArrayUtils.isEmpty((Object[])args) || args.length != 1) {
                    throw new IllegalArgumentException("Invalid argument");
                }
                this.setNavigationPropertyValue(navProp, args[0]);
            } else {
                this.setPropertyValue(property, args[0]);
            }
            return ClassUtils.returnVoid();
        }
        throw new NoSuchMethodException(method.getName());
    }

    public void delete(String name) {
        if (this.baseURI != null) {
            this.getContext().entityContext().addFurtherDeletes(this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name).appendValueSegment().build());
        }
    }

    public void delete() {
        EntityContext entityContext = this.getContext().entityContext();
        if (this instanceof EntityInvocationHandler) {
            this.deleteEntity((EntityInvocationHandler)EntityInvocationHandler.class.cast(this), null);
        } else if (this.baseURI != null) {
            entityContext.addFurtherDeletes(this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendValueSegment().build());
        }
    }

    protected void attach() {
        this.attach(AttachedEntityStatus.ATTACHED, false);
    }

    protected void attach(AttachedEntityStatus status) {
        this.attach(status, true);
    }

    protected void attach(AttachedEntityStatus status, boolean override) {
        if (this.getContext().entityContext().isAttached(this.getEntityHandler())) {
            if (override) {
                this.getContext().entityContext().setStatus(this.getEntityHandler(), status);
            }
        } else {
            this.getContext().entityContext().attach(this.getEntityHandler(), status);
        }
    }

    protected Object getPropertyValue(String name, Type type) {
        try {
            Object res;
            Class ref = ClassUtils.getTypeClass((Type)type);
            if (ref == EdmStreamValue.class) {
                Object res2;
                if (this.streamedPropertyCache.containsKey(name)) {
                    res2 = this.streamedPropertyCache.get(name);
                } else if (this.streamedPropertyChanges.containsKey(name)) {
                    res2 = this.streamedPropertyChanges.get(name);
                } else {
                    res2 = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EdmStreamValue.class}, (InvocationHandler)new EdmStreamValueHandler(this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name).build(), this.service));
                    this.streamedPropertyCache.put(name, EdmStreamValue.class.cast(res2));
                }
                return res2;
            }
            if (this.propertyChanges.containsKey(name)) {
                res = this.propertyChanges.get(name);
            } else if (this.propertyCache.containsKey(name)) {
                res = this.propertyCache.get(name);
            } else {
                CommonODataProperty property = this.getInternalProperty(name);
                if (ref != null && ClassUtils.getTypeClass((Type)type).isAnnotationPresent(ComplexType.class)) {
                    res = this.getComplex(name, property == null || property.hasNullValue() ? null : property.getValue(), ref, this.getEntityHandler(), this.baseURI, false);
                } else if (ref != null && ComplexCollection.class.isAssignableFrom(ref)) {
                    ComplexCollectionInvocationHandler collectionHandler;
                    Class itemRef = ClassUtils.extractTypeArg((Class)ref, (Class[])new Class[]{ComplexCollection.class});
                    if (property == null || property.hasNullValue()) {
                        collectionHandler = new ComplexCollectionInvocationHandler(itemRef, this.service, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    } else {
                        ArrayList<org.apache.olingo.ext.proxy.api.ComplexType> items = new ArrayList<org.apache.olingo.ext.proxy.api.ComplexType>();
                        for (ODataValue item : property.getValue().asCollection()) {
                            items.add(this.getComplex(name, item, itemRef, this.getEntityHandler(), null, true));
                        }
                        collectionHandler = new ComplexCollectionInvocationHandler(this.service, items, itemRef, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    }
                    res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, (InvocationHandler)collectionHandler);
                } else if (ref != null && PrimitiveCollection.class.isAssignableFrom(ref)) {
                    PrimitiveCollectionInvocationHandler collectionHandler;
                    if (property == null || property.hasNullValue()) {
                        collectionHandler = new PrimitiveCollectionInvocationHandler(this.service, null, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    } else {
                        ArrayList<Object> items = new ArrayList<Object>();
                        for (ODataValue item : property.getValue().asCollection()) {
                            items.add(item.asPrimitive().toValue());
                        }
                        collectionHandler = new PrimitiveCollectionInvocationHandler(this.service, items, null, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    }
                    res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{PrimitiveCollection.class}, (InvocationHandler)collectionHandler);
                } else {
                    Object v = res = property == null || property.hasNullValue() ? null : CoreUtils.getObjectFromODataValue((ODataValue)property.getValue(), (Type)type, (AbstractService)this.service);
                }
            }
            if (res != null) {
                this.addPropertyChanges(name, res);
                this.propertyCache.put(name, res);
            }
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting value for property '" + name + "'", e);
        }
    }

    protected void setPropertyValue(Property property, Object value) {
        if (EdmPrimitiveTypeKind.Stream.getFullQualifiedName().toString().equalsIgnoreCase(property.type())) {
            this.setStreamedProperty(property, (EdmStreamValue)value);
        } else {
            this.addPropertyChanges(property.name(), value);
            if (value != null) {
                Collection<Object> coll = Collection.class.isAssignableFrom(value.getClass()) ? (Collection)Collection.class.cast(value) : Collections.singleton(value);
                for (Object e : coll) {
                    InvocationHandler handler;
                    if (!(e instanceof Proxy) || !((handler = Proxy.getInvocationHandler(e)) instanceof ComplexInvocationHandler) || ((ComplexInvocationHandler)handler).getEntityHandler() != null) continue;
                    ((ComplexInvocationHandler)handler).setEntityHandler(this.getEntityHandler());
                }
            }
        }
        this.attach(AttachedEntityStatus.CHANGED);
    }

    private void setStreamedProperty(Property property, EdmStreamValue input) {
        Object obj = this.streamedPropertyChanges.get(property.name());
        if (obj instanceof InputStream) {
            IOUtils.closeQuietly((InputStream)((InputStream)obj));
        }
        this.streamedPropertyCache.remove(property.name());
        this.streamedPropertyChanges.put(property.name(), input.load());
    }

    protected abstract Object getNavigationPropertyValue(NavigationProperty var1, Method var2);

    protected Object retrieveNavigationProperty(NavigationProperty property, Method getter) {
        Object navPropValue;
        Class type = getter.getReturnType();
        Class collItemType = EntityCollection.class.isAssignableFrom(type) ? ClassUtils.extractTypeArg(type, (Class[])new Class[]{EntityCollection.class, ComplexCollection.class}) : type;
        URI targetEntitySetURI = CoreUtils.getTargetEntitySetURI((CommonEdmEnabledODataClient)this.getClient(), (NavigationProperty)property);
        ODataLink link = ((ODataLinked)this.internal).getNavigationLink(property.name());
        if (link instanceof ODataInlineEntity) {
            navPropValue = ProxyUtils.getEntityProxy((AbstractService)this.service, (CommonODataEntity)((ODataInlineEntity)link).getEntity(), (URI)targetEntitySetURI, (Class)type, null, (boolean)false);
        } else if (link instanceof ODataInlineEntitySet) {
            navPropValue = ProxyUtils.getEntityCollectionProxy((AbstractService)this.service, (Class)collItemType, (Class)type, (URI)targetEntitySetURI, (CommonODataEntitySet)((ODataInlineEntitySet)link).getEntitySet(), (URI)targetEntitySetURI, (boolean)false);
        } else {
            URI targetURI = URIUtils.getURI((URI)this.getEntityHandler().getEntityURI(), (String)property.name());
            if (EntityCollection.class.isAssignableFrom(type)) {
                navPropValue = ProxyUtils.getEntityCollectionProxy((AbstractService)this.service, (Class)collItemType, (Class)type, (URI)targetEntitySetURI, null, (URI)targetURI, (boolean)true);
            } else if (AbstractEntitySet.class.isAssignableFrom(type)) {
                navPropValue = ProxyUtils.getEntitySetProxy((AbstractService)this.service, (Class)type, (URI)targetURI);
            } else {
                EntityUUID uuid = new EntityUUID(targetEntitySetURI, collItemType, null);
                LOG.debug("Ask for '{}({})'", (Object)collItemType.getSimpleName(), null);
                EntityInvocationHandler handler = this.getContext().entityContext().getEntity(uuid);
                if (handler == null) {
                    CommonODataEntity entity = this.getClient().getObjectFactory().newEntity(new FullQualifiedName(collItemType.getAnnotation(Namespace.class).value(), ClassUtils.getEntityTypeName((Class)collItemType)));
                    handler = EntityInvocationHandler.getInstance((CommonODataEntity)entity, (URI)URIUtils.getURI((URI)this.uri.build(), (String)property.name()), (URI)targetEntitySetURI, (Class)collItemType, (AbstractService)this.service);
                } else if (this.getContext().entityContext().getStatus(handler) == AttachedEntityStatus.DELETED) {
                    LOG.debug("Object '{}({})' has been deleted", (Object)collItemType.getSimpleName(), (Object)uuid);
                    handler = null;
                }
                navPropValue = handler == null ? null : Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collItemType}, (InvocationHandler)handler);
            }
        }
        return navPropValue;
    }

    public Object getAdditionalProperty(String name) {
        return this.getPropertyValue(name, null);
    }

    public Map<String, Object> getPropertyChanges() {
        return this.propertyChanges;
    }

    public Collection<String> getAdditionalPropertyNames() {
        HashSet<String> res = new HashSet<String>(this.propertyChanges.keySet());
        HashSet<String> propertyNames = new HashSet<String>();
        for (Method method : this.typeRef.getMethods()) {
            Property ann = method.getAnnotation(Property.class);
            if (ann == null) continue;
            String property = ann.name();
            propertyNames.add(property);
            res.remove(property);
        }
        for (CommonODataProperty property : this.getInternalProperties()) {
            if (propertyNames.contains(property.getName())) continue;
            res.add(property.getName());
        }
        return res;
    }

    public void addAdditionalProperty(String name, Object value) {
        this.propertyChanges.put(name, value);
        this.attach(AttachedEntityStatus.CHANGED);
    }

    public Map<NavigationProperty, Object> getLinkChanges() {
        return this.linkChanges;
    }

    public void removeAdditionalProperty(String name) {
        this.propertyChanges.remove(name);
        this.attach(AttachedEntityStatus.CHANGED);
    }

    protected void addPropertyChanges(String name, Object value) {
        int checkpoint = ((Object)this.propertyChanges).hashCode();
        this.updatePropertiesTag(checkpoint);
        this.propertyChanges.put(name, value);
    }

    protected void addLinkChanges(NavigationProperty navProp, Object value) {
        int checkpoint = ((Object)this.linkChanges).hashCode();
        this.updateLinksTag(checkpoint);
        this.linkChanges.put(navProp, value);
        if (this.linkCache.containsKey(navProp)) {
            this.linkCache.remove(navProp);
        }
    }

    protected void updatePropertiesTag(int checkpoint) {
        if (this.propertiesTag == 0 || checkpoint == this.propertiesTag) {
            this.propertiesTag = ((Object)this.propertyChanges).hashCode();
        }
    }

    protected void updateLinksTag(int checkpoint) {
        if (this.linksTag == 0 || checkpoint == this.linksTag) {
            this.linksTag = ((Object)this.linkChanges).hashCode();
        }
    }

    public Map<String, EdmStreamValue> getStreamedPropertyChanges() {
        return this.streamedPropertyChanges;
    }

    private void setNavigationPropertyValue(NavigationProperty property, Object value) {
        if (!this.getContext().entityContext().isAttached(this.getEntityHandler())) {
            this.getContext().entityContext().attach(this.getEntityHandler(), AttachedEntityStatus.CHANGED);
        }
        this.addLinkChanges(property, value);
    }

    public Map<String, AnnotatableInvocationHandler> getPropAnnotatableHandlers() {
        return this.propAnnotatableHandlers;
    }

    public void putPropAnnotatableHandler(String propName, AnnotatableInvocationHandler handler) {
        this.propAnnotatableHandlers.put(propName, handler);
    }

    public Map<String, AnnotatableInvocationHandler> getNavPropAnnotatableHandlers() {
        return this.navPropAnnotatableHandlers;
    }

    public void putNavPropAnnotatableHandler(String navPropName, AnnotatableInvocationHandler handler) {
        this.navPropAnnotatableHandlers.put(navPropName, handler);
    }

    public void expand(String ... expand) {
        this.uri.expand(expand);
    }

    public void select(String ... select) {
        this.uri.select(select);
    }

    public void refs() {
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V40) >= 0) {
            ((URIBuilder)this.uri).appendRefSegment();
        }
    }

    public void clearQueryOptions() {
        this.uri = this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString());
    }

    protected abstract void load();

    public abstract boolean isChanged();

    protected abstract <T extends CommonODataProperty> List<T> getInternalProperties();

    protected abstract CommonODataProperty getInternalProperty(String var1);
}

