/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.communication.request.retrieve.ODataValueRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.v3.UnsupportedInV3Exception;
import org.apache.olingo.client.api.v4.EdmEnabledODataClient;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.AbstractSingleton;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.Search;
import org.apache.olingo.ext.proxy.api.StructuredType;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.commons.AbstractEntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetIterator;
import org.apache.olingo.ext.proxy.commons.SearchImpl;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityContext;
import org.apache.olingo.ext.proxy.context.EntityUUID;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntitySetInvocationHandler<T extends EntityType<?>, KEY extends Serializable, EC extends EntityCollection<T, ?, ?>>
extends AbstractEntityCollectionInvocationHandler<T, EC>
implements AbstractEntitySet<T, KEY, EC> {
    private static final long serialVersionUID = 2629912294765040027L;

    public static EntitySetInvocationHandler getInstance(Class<?> ref, AbstractService<?> service) {
        return new EntitySetInvocationHandler(ref, service, EntitySetInvocationHandler.buildEntitySetURI(ref, service));
    }

    public static EntitySetInvocationHandler getInstance(Class<?> ref, AbstractService<?> service, URI uri) {
        return new EntitySetInvocationHandler(ref, service, service.getClient().newURIBuilder(uri.toASCIIString()));
    }

    protected EntitySetInvocationHandler(Class<?> ref, AbstractService<?> service, CommonURIBuilder<?> uri) {
        super(ref, service, uri);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("filter".equals(method.getName()) || "orderBy".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "expand".equals(method.getName()) || "select".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        throw new NoSuchMethodException(method.getName());
    }

    public Long count() {
        ODataValueRequest req = this.getClient().getRetrieveRequestFactory().getValueRequest(this.getClient().newURIBuilder(this.uri.build().toASCIIString()).count().build());
        req.setFormat(ODataFormat.TEXT_PLAIN);
        return Long.valueOf(((ODataPrimitiveValue)((ODataRetrieveResponse)req.execute()).getBody()).asPrimitive().toString());
    }

    public Boolean exists(KEY key) throws IllegalArgumentException {
        try {
            ((StructuredType)StructuredType.class.cast(this.getByKey(key))).load();
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not check existence of {}({})", new Object[]{this.uri, key, e});
            return false;
        }
    }

    public T getByKey(KEY key) throws IllegalArgumentException {
        return (T)this.getByKey(key, this.itemRef);
    }

    public <S extends T> S getByKey(KEY key, Class<S> typeRef) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        EntityUUID uuid = new EntityUUID(this.baseURI, typeRef, key);
        LOG.debug("Ask for '{}({})'", (Object)typeRef.getSimpleName(), key);
        EntityInvocationHandler handler = this.getContext().entityContext().getEntity(uuid);
        if (handler == null) {
            CommonODataEntity entity = this.getClient().getObjectFactory().newEntity(new FullQualifiedName(typeRef.getAnnotation(Namespace.class).value(), ClassUtils.getEntityTypeName(typeRef)));
            handler = EntityInvocationHandler.getInstance(key, (CommonODataEntity)entity, (URI)this.baseURI, typeRef, (AbstractService)this.service);
        }
        if (this.isDeleted(handler)) {
            LOG.debug("Object '{}({})' has been deleted", (Object)typeRef.getSimpleName(), (Object)uuid);
            return null;
        }
        return (S)((EntityType)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{typeRef}, (InvocationHandler)handler));
    }

    public EC execute() {
        return (EC)this.execute(this.collItemRef);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> Future<SEC> executeAsync(Class<SEC> collTypeRef) {
        return this.service.getClient().getConfiguration().getExecutor().submit(new /* Unavailable Anonymous Inner Class!! */);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> SEC execute(Class<SEC> collTypeRef) {
        Class ref = ClassUtils.extractTypeArg(collTypeRef, (Class[])new Class[]{AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class});
        Class oref = ClassUtils.extractTypeArg((Class)this.collItemRef, (Class[])new Class[]{AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class});
        CommonURIBuilder uriBuilder = this.getClient().newURIBuilder(this.uri.build().toASCIIString());
        if (!oref.equals(ref)) {
            uriBuilder.appendDerivedEntityTypeSegment(new FullQualifiedName(ClassUtils.getNamespace((Class)ref), ClassUtils.getEntityTypeName((Class)ref)).toString());
        }
        ArrayList anns = new ArrayList();
        Triple entitySet = this.fetchPartial(uriBuilder.build(), ref);
        anns.addAll((Collection)entitySet.getRight());
        EntityCollectionInvocationHandler entityCollectionHandler = new EntityCollectionInvocationHandler(this.service, (Collection)((List)entitySet.getLeft()), collTypeRef, this.baseURI, uriBuilder);
        entityCollectionHandler.setAnnotations(anns);
        entityCollectionHandler.nextPageURI = (URI)entitySet.getMiddle();
        return (SEC)((EntityCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collTypeRef}, (InvocationHandler)entityCollectionHandler));
    }

    public Search<T, EC> createSearch() {
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            throw new UnsupportedInV3Exception();
        }
        return new SearchImpl((EdmEnabledODataClient)this.getClient(), this.collItemRef, this.baseURI, this);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> Search<S, SEC> createSearch(Class<SEC> reference) {
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            throw new UnsupportedInV3Exception();
        }
        return new SearchImpl((EdmEnabledODataClient)this.getClient(), reference, this.baseURI, this);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> SEC fetchWholeEntitySet(CommonURIBuilder<?> uriBuilder, Class<S> typeRef, Class<SEC> collTypeRef) {
        ArrayList res = new ArrayList();
        ArrayList anns = new ArrayList();
        URI nextURI = uriBuilder.build();
        while (nextURI != null) {
            Triple entitySet = this.fetchPartial(nextURI, typeRef);
            res.addAll((List)entitySet.getLeft());
            nextURI = (URI)entitySet.getMiddle();
            anns.addAll((Collection)entitySet.getRight());
        }
        EntityCollectionInvocationHandler entityCollectionHandler = new EntityCollectionInvocationHandler(this.service, res, collTypeRef, this.targetEntitySetURI, uriBuilder);
        entityCollectionHandler.setAnnotations(anns);
        return (SEC)((EntityCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collTypeRef}, (InvocationHandler)entityCollectionHandler));
    }

    public void delete(KEY key) throws IllegalArgumentException {
        EntityContext entityContext = this.getContext().entityContext();
        EntityInvocationHandler entity = entityContext.getEntity(new EntityUUID(this.baseURI, this.itemRef, key));
        if (entity == null) {
            EntityType searched = this.getByKey(key);
            entity = (EntityInvocationHandler)Proxy.getInvocationHandler(searched);
            entityContext.attach(entity, AttachedEntityStatus.DELETED);
        } else {
            entityContext.setStatus(entity, AttachedEntityStatus.DELETED);
        }
    }

    public <S extends T> void delete(S entity) {
        this.deleteEntity((EntityInvocationHandler)Proxy.getInvocationHandler(entity), this.baseURI);
    }

    public <S extends T> void delete(Iterable<S> entities) {
        for (EntityType en : entities) {
            this.delete(en);
        }
    }

    public EntitySetIterator<T, KEY, EC> iterator() {
        return new EntitySetIterator(this.getClient().newURIBuilder(this.uri.build().toASCIIString()).build(), this);
    }
}

