/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.uri.v4.URIBuilder;
import org.apache.olingo.client.api.uri.v4.URISearch;
import org.apache.olingo.client.api.v4.EdmEnabledODataClient;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.Search;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public class SearchImpl<T extends EntityType<?>, EC extends EntityCollection<T, ?, ?>>
implements Search<T, EC> {
    private static final long serialVersionUID = 4383858176507769973L;
    private final EdmEnabledODataClient client;
    private final Class<T> typeRef;
    private final Class<EC> collTypeRef;
    private final EntitySetInvocationHandler<T, ?, EC> handler;
    private final URI baseURI;
    private String search;

    SearchImpl(EdmEnabledODataClient client, Class<EC> collTypeRef, URI baseURI, EntitySetInvocationHandler<T, ?, EC> handler) {
        this.client = client;
        this.typeRef = ClassUtils.extractTypeArg(collTypeRef, (Class[])new Class[]{EntityCollection.class});
        this.collTypeRef = collTypeRef;
        this.baseURI = baseURI;
        this.handler = handler;
    }

    public Search<T, EC> setSearch(String search) {
        this.search = search;
        return this;
    }

    public Search<T, EC> setSearch(URISearch search) {
        this.search = search.build();
        return this;
    }

    public String getSearch() {
        return this.search;
    }

    public EC getResult() {
        URIBuilder uriBuilder = (URIBuilder)this.client.newURIBuilder(this.baseURI.toASCIIString()).appendDerivedEntityTypeSegment(new FullQualifiedName(ClassUtils.getNamespace((Class)this.typeRef), ClassUtils.getEntityTypeName((Class)this.typeRef)).toString());
        if (StringUtils.isNotBlank((CharSequence)this.search)) {
            uriBuilder.search(this.search);
        }
        return (EC)this.handler.fetchWholeEntitySet((CommonURIBuilder)uriBuilder, this.typeRef, this.collTypeRef);
    }
}

