/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.V3Services;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.springframework.stereotype.Service;

@Service
@Path(value="/V30/OpenType.svc")
public class V3OpenType
extends V3Services {
    private static final Pattern GUID = Pattern.compile("guid'(.*)'");

    public V3OpenType() throws IOException {
        super(new Metadata(FSManager.instance((ODataServiceVersion)ODataServiceVersion.V30).readRes("openType" + StringUtils.capitalize((String)Constants.get((ODataServiceVersion)ODataServiceVersion.V30, (ConstantKey)ConstantKey.METADATA)), Accept.XML), ODataServiceVersion.V30));
    }

    private Response replaceServiceName(Response response) {
        try {
            String content = IOUtils.toString((InputStream)((InputStream)response.getEntity()), (Charset)Constants.ENCODING).replaceAll("Static\\.svc", "OpenType.svc");
            Response.ResponseBuilder builder = Response.status((int)response.getStatus());
            for (String headerName : response.getHeaders().keySet()) {
                for (Object headerValue : (List)response.getHeaders().get((Object)headerName)) {
                    builder.header(headerName, headerValue);
                }
            }
            InputStream toBeStreamedBack = IOUtils.toInputStream((String)content, (Charset)Constants.ENCODING);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)toBeStreamedBack, (OutputStream)baos);
            IOUtils.closeQuietly((InputStream)toBeStreamedBack);
            builder.header("Content-Length", (Object)baos.size());
            builder.entity((Object)new ByteArrayInputStream(baos.toByteArray()));
            return builder.build();
        }
        catch (Exception e) {
            return response;
        }
    }

    @GET
    @Path(value="/$metadata")
    @Produces(value={"application/xml"})
    public Response getMetadata() {
        return super.getMetadata("openType" + StringUtils.capitalize((String)Constants.get((ODataServiceVersion)ODataServiceVersion.V30, (ConstantKey)ConstantKey.METADATA)));
    }

    @GET
    @Path(value="/{entitySetName}({entityId})")
    public Response getEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$expand") @DefaultValue(value="") String expand, @QueryParam(value="$select") @DefaultValue(value="") String select) {
        Matcher matcher = GUID.matcher(entityId);
        return this.replaceServiceName(super.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, entitySetName, matcher.matches() ? matcher.group(1) : entityId, format, expand, select));
    }

    @POST
    @Path(value="/{entitySetName}")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json", "application/octet-stream"})
    public Response postNewEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, String entity) {
        return this.replaceServiceName(super.postNewEntity(uriInfo, accept, contentType, prefer, entitySetName, entity));
    }

    @DELETE
    @Path(value="/{entitySetName}({entityId})")
    public Response removeEntity(@PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId) {
        Matcher matcher = GUID.matcher(entityId);
        return this.replaceServiceName(super.removeEntity(entitySetName, matcher.matches() ? matcher.group(1) : entityId));
    }
}

