/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.apache.olingo.fit.utils.XMLUtilities;
import org.springframework.stereotype.Service;

@Service
@Path(value="/V40/Vocabularies.svc")
public class V4Vocabularies {
    private final Metadata metadata = new Metadata(FSManager.instance((ODataServiceVersion)ODataServiceVersion.V40).readRes("vocabularies-" + Constants.get((ODataServiceVersion)ODataServiceVersion.V40, (ConstantKey)ConstantKey.METADATA), Accept.XML), ODataServiceVersion.V40);
    private final XMLUtilities xml = new XMLUtilities(ODataServiceVersion.V40, this.metadata);

    @GET
    @Path(value="/$metadata")
    @Produces(value={"application/xml"})
    public Response getMetadata() {
        try {
            return this.xml.createResponse(null, FSManager.instance((ODataServiceVersion)ODataServiceVersion.V40).readRes("vocabularies-" + Constants.get((ODataServiceVersion)ODataServiceVersion.V40, (ConstantKey)ConstantKey.METADATA), Accept.XML), null, Accept.XML);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.XML.toString(ODataServiceVersion.V40), e);
        }
    }

    @GET
    @Path(value="/{vocabulary}")
    @Produces(value={"application/xml"})
    public Response getVocabulary(@PathParam(value="vocabulary") String vocabulary) {
        try {
            return this.xml.createResponse(null, FSManager.instance((ODataServiceVersion)ODataServiceVersion.V40).readFile(vocabulary, null), null, Accept.XML);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.XML.toString(ODataServiceVersion.V40), e);
        }
    }
}

