/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.olingo.fit.metadata.AbstractMetadataElement;
import org.apache.olingo.fit.metadata.AssociationSet;
import org.apache.olingo.fit.metadata.EntitySet;

public class Container
extends AbstractMetadataElement {
    private final String name;
    private final Map<String, EntitySet> entitySets;
    private final Map<String, AssociationSet> associationSets;

    public Container(String name) {
        this.name = name;
        this.entitySets = new HashMap();
        this.associationSets = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public AssociationSet getAssociationSet(String association) {
        return (AssociationSet)this.associationSets.get(association);
    }

    public Collection<EntitySet> getEntitySets() {
        return this.entitySets.values();
    }

    public Collection<EntitySet> getEntitySets(String namespace, String entityTypeName) {
        HashSet<EntitySet> res = new HashSet<EntitySet>();
        for (EntitySet entitySet : this.entitySets.values()) {
            if (!(namespace + "." + entityTypeName).equals(entitySet.getType())) continue;
            res.add(entitySet);
        }
        return res;
    }

    public EntitySet getEntitySet(String name) {
        return (EntitySet)this.entitySets.get(name);
    }

    public Container addEntitySet(String name, EntitySet entitySet) {
        this.entitySets.put(name, entitySet);
        return this;
    }

    public Container addAssociationSet(String name, AssociationSet associationSet) {
        this.associationSets.put(name, associationSet);
        return this;
    }
}

