/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.olingo.fit.metadata.AbstractMetadataElement;
import org.apache.olingo.fit.metadata.NavigationProperty;
import org.apache.olingo.fit.metadata.Property;

public class EntityType
extends AbstractMetadataElement {
    private final String name;
    private String baseType;
    private boolean openType = false;
    private final Map<String, Property> properties;
    private final Map<String, NavigationProperty> navigationProperties;

    public EntityType(String name) {
        this.name = name;
        this.properties = new HashMap();
        this.navigationProperties = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean isOpenType() {
        return this.openType;
    }

    public void setOpenType(boolean openType) {
        this.openType = openType;
    }

    public Collection<NavigationProperty> getNavigationProperties() {
        return new HashSet<NavigationProperty>(this.navigationProperties.values());
    }

    public Map<String, NavigationProperty> getNavigationPropertyMap() {
        return new HashMap<String, NavigationProperty>(this.navigationProperties);
    }

    public Map<String, Property> getPropertyMap() {
        return new HashMap<String, Property>(this.properties);
    }

    public Collection<Property> getProperties() {
        return new HashSet<Property>(this.properties.values());
    }

    public Property getProperty(String name) {
        return (Property)this.properties.get(name);
    }

    public EntityType addProperty(String name, Property property) {
        this.properties.put(name, property);
        return this;
    }

    public NavigationProperty getNavigationProperty(String name) {
        return (NavigationProperty)this.navigationProperties.get(name);
    }

    public EntityType addNavigationProperty(String name, NavigationProperty property) {
        this.navigationProperties.put(name, property);
        return this;
    }
}

