/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.metadata;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.metadata.AbstractMetadataElement;
import org.apache.olingo.fit.metadata.Association;
import org.apache.olingo.fit.metadata.AssociationSet;
import org.apache.olingo.fit.metadata.Container;
import org.apache.olingo.fit.metadata.EntitySet;
import org.apache.olingo.fit.metadata.EntityType;
import org.apache.olingo.fit.metadata.NavigationProperty;
import org.apache.olingo.fit.metadata.Property;
import org.apache.olingo.fit.metadata.Schema;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata
extends AbstractMetadataElement {
    protected static final Logger LOG = LoggerFactory.getLogger(Metadata.class);
    protected final ODataServiceVersion version;
    private final Map<String, Schema> schemas;
    private final String DEF_NS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata(InputStream is, ODataServiceVersion version) {
        this.version = version;
        this.DEF_NS = Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.EDM_NS);
        this.schemas = new HashMap();
        try {
            XMLInputFactory ifactory = XMLInputFactory.newInstance();
            XMLEventReader reader = ifactory.createXMLEventReader(is, "UTF-8");
            try {
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement() || !event.asStartElement().getName().equals(new QName(this.DEF_NS, "Schema"))) continue;
                    Schema schema = this.getSchema(event.asStartElement(), reader);
                    this.schemas.put(schema.getNamespace(), schema);
                }
            }
            catch (Exception ignore) {
            }
            finally {
                reader.close();
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (Exception e) {
            LOG.error("Error parsing metadata", (Throwable)e);
        }
        for (Map.Entry schemaEntry : this.schemas.entrySet()) {
            for (EntityType entityType : ((Schema)schemaEntry.getValue()).getEntityTypes()) {
                for (NavigationProperty property : entityType.getNavigationProperties()) {
                    if (StringUtils.isNotBlank((CharSequence)property.getReleationship())) {
                        Association association = ((Schema)schemaEntry.getValue()).getAssociation(property.getReleationship().replaceAll((String)schemaEntry.getKey() + "\\.", ""));
                        Association.Role role = association.getRole(property.getToRole());
                        property.setFeed(role.getMultiplicity().equals("*"));
                        property.setType(property.isEntitySet() ? "Collection(" + role.getType() + ")" : role.getType());
                        AssociationSet associationSet = ((Container)((Schema)schemaEntry.getValue()).getContainers().iterator().next()).getAssociationSet(property.getReleationship());
                        AssociationSet.Role associationSetRole = associationSet.getRole(property.getToRole());
                        property.setTarget(associationSetRole.getEntitySet());
                        continue;
                    }
                    property.setFeed(property.getType().startsWith("Collection("));
                    Collection entitySets = ((Container)((Schema)schemaEntry.getValue()).getContainers().iterator().next()).getEntitySets((String)schemaEntry.getKey(), entityType.getName());
                    Iterator iter = entitySets.iterator();
                    boolean found = false;
                    while (!found && iter.hasNext()) {
                        EntitySet entitySet = (EntitySet)iter.next();
                        String target = entitySet.getTarget(property.getName());
                        if (!StringUtils.isNotBlank((CharSequence)target)) continue;
                        property.setTarget(entitySet.getTarget(property.getName()));
                        found = true;
                    }
                }
            }
        }
    }

    public EntitySet getEntitySet(String name) {
        for (Schema schema : this.getSchemas()) {
            for (Container container : schema.getContainers()) {
                EntitySet entitySet = container.getEntitySet(name);
                if (entitySet == null) continue;
                return entitySet;
            }
        }
        return null;
    }

    public EntityType getEntityOrComplexType(String fqn) {
        EntityType result = null;
        String ns = StringUtils.substringBeforeLast((String)fqn, (String)".");
        if (this.getSchema(ns) != null) {
            String baseNS;
            String name = StringUtils.substringAfterLast((String)fqn, (String)".");
            result = this.getSchema(ns).getEntityType(name);
            if (result != null && result.getBaseType() != null && this.getSchema(baseNS = StringUtils.substringBeforeLast((String)result.getBaseType(), (String)".")) != null) {
                String baseName = StringUtils.substringAfterLast((String)result.getBaseType(), (String)".");
                EntityType baseType = this.getSchema(baseNS).getEntityType(baseName);
                if (baseType != null) {
                    for (Map.Entry entry : baseType.getPropertyMap().entrySet()) {
                        result.addProperty((String)entry.getKey(), (Property)entry.getValue());
                    }
                    for (Map.Entry entry : baseType.getNavigationPropertyMap().entrySet()) {
                        result.addNavigationProperty((String)entry.getKey(), (NavigationProperty)entry.getValue());
                    }
                }
            }
        }
        return result;
    }

    public Map<String, NavigationProperty> getNavigationProperties(String entitySetName) {
        for (Schema schema : this.getSchemas()) {
            for (Container container : schema.getContainers()) {
                EntitySet entitySet = container.getEntitySet(entitySetName);
                if (entitySet == null) continue;
                String entityTypeFQN = entitySet.getType();
                int lastDotIndex = entityTypeFQN.lastIndexOf(46);
                String entityTypeNS = entityTypeFQN.substring(0, lastDotIndex);
                String entityTypeName = entityTypeFQN.substring(lastDotIndex + 1);
                EntityType entityType = this.getSchema(entityTypeNS).getEntityType(entityTypeName);
                return entityType.getNavigationPropertyMap();
            }
        }
        return null;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    public Schema getSchema(String namespace) {
        return (Schema)this.schemas.get(namespace);
    }

    public Metadata addSchema(String namespace, Schema schema) {
        this.schemas.put(namespace, schema);
        return this;
    }

    private Schema getSchema(StartElement start, XMLEventReader reader) throws XMLStreamException {
        Schema schema = new Schema(start.getAttributeByName(new QName("Namespace")).getValue());
        boolean completed = false;
        while (!completed && reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "EntityType")) || event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "ComplexType"))) {
                EntityType entityType = this.getEntityType(event.asStartElement(), reader);
                schema.addEntityType(entityType.getName(), entityType);
                continue;
            }
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "EntityContainer"))) {
                Container container = this.getContainer(event.asStartElement(), reader);
                schema.addContainer(container.getName(), container);
                continue;
            }
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "Association"))) {
                Association association = this.getAssociation(event.asStartElement(), reader);
                schema.addAssociation(association.getName(), association);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(start.getName())) continue;
            completed = true;
        }
        return schema;
    }

    private Container getContainer(StartElement start, XMLEventReader reader) throws XMLStreamException {
        Container container = new Container(start.getAttributeByName(new QName("Name")).getValue());
        boolean completed = false;
        while (!completed && reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && (event.asStartElement().getName().equals(new QName(this.DEF_NS, "EntitySet")) || event.asStartElement().getName().equals(new QName(this.DEF_NS, "Singleton")))) {
                EntitySet entitySet = this.getEntitySet(event.asStartElement(), reader);
                container.addEntitySet(entitySet.getName(), entitySet);
                continue;
            }
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "AssociationSet"))) {
                AssociationSet associationSet = this.getAssociationSet(event.asStartElement(), reader);
                container.addAssociationSet(associationSet.getAssociation(), associationSet);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(start.getName())) continue;
            completed = true;
        }
        return container;
    }

    private Association getAssociation(StartElement start, XMLEventReader reader) throws XMLStreamException {
        Association association = new Association(start.getAttributeByName(new QName("Name")).getValue());
        boolean completed = false;
        while (!completed && reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "End"))) {
                String role = event.asStartElement().getAttributeByName(new QName("Role")).getValue();
                String type = event.asStartElement().getAttributeByName(new QName("Type")).getValue();
                String multiplicity = event.asStartElement().getAttributeByName(new QName("Multiplicity")).getValue();
                association.addRole(role, type, multiplicity);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(start.getName())) continue;
            completed = true;
        }
        return association;
    }

    private AssociationSet getAssociationSet(StartElement start, XMLEventReader reader) throws XMLStreamException {
        AssociationSet associationSet = new AssociationSet(start.getAttributeByName(new QName("Name")).getValue(), start.getAttributeByName(new QName("Association")).getValue());
        boolean completed = false;
        while (!completed && reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "End"))) {
                String role = event.asStartElement().getAttributeByName(new QName("Role")).getValue();
                String entitySet = event.asStartElement().getAttributeByName(new QName("EntitySet")).getValue();
                associationSet.addRole(role, entitySet);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(start.getName())) continue;
            completed = true;
        }
        return associationSet;
    }

    private EntityType getEntityType(StartElement start, XMLEventReader reader) throws XMLStreamException {
        Attribute openType;
        EntityType entityType = new EntityType(start.getAttributeByName(new QName("Name")).getValue());
        Attribute baseType = start.getAttributeByName(new QName("BaseType"));
        if (baseType != null) {
            entityType.setBaseType(baseType.getValue());
        }
        if ((openType = start.getAttributeByName(new QName("OpenType"))) != null) {
            entityType.setOpenType(BooleanUtils.toBoolean((String)openType.getValue()));
        }
        boolean completed = false;
        while (!completed && reader.hasNext()) {
            Property property;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "Property"))) {
                property = this.getProperty(event.asStartElement());
                entityType.addProperty(property.getName(), property);
                continue;
            }
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "NavigationProperty"))) {
                property = this.getNavigationProperty(event.asStartElement());
                entityType.addNavigationProperty(property.getName(), (NavigationProperty)property);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(start.getName())) continue;
            completed = true;
        }
        return entityType;
    }

    private Property getProperty(StartElement start) throws XMLStreamException {
        Property property = new Property(start.getAttributeByName(new QName("Name")).getValue());
        Attribute type = start.getAttributeByName(new QName("Type"));
        property.setType(type == null ? "Edm.String" : type.getValue());
        Attribute nullable = start.getAttributeByName(new QName("Nullable"));
        property.setNullable(nullable == null || !"false".equals(nullable.getValue()));
        return property;
    }

    private NavigationProperty getNavigationProperty(StartElement start) throws XMLStreamException {
        Attribute toRole;
        Attribute relationship;
        NavigationProperty property = new NavigationProperty(start.getAttributeByName(new QName("Name")).getValue());
        Attribute type = start.getAttributeByName(new QName("Type"));
        if (type != null) {
            property.setType(type.getValue());
        }
        if ((relationship = start.getAttributeByName(new QName("Relationship"))) != null) {
            property.setReleationship(relationship.getValue());
        }
        if ((toRole = start.getAttributeByName(new QName("ToRole"))) != null) {
            property.setToRole(toRole.getValue());
        }
        return property;
    }

    private EntitySet getEntitySet(StartElement start, XMLEventReader reader) throws XMLStreamException {
        EntitySet entitySet = "Singleton".equals(start.getName().getLocalPart()) ? new EntitySet(start.getAttributeByName(new QName("Name")).getValue(), true) : new EntitySet(start.getAttributeByName(new QName("Name")).getValue());
        Attribute type = start.getAttributeByName(new QName("EntityType"));
        if (type == null) {
            type = start.getAttributeByName(new QName("Type"));
            entitySet.setType(type == null ? null : type.getValue());
        } else {
            entitySet.setType(type.getValue());
        }
        boolean completed = false;
        while (!completed && reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(new QName(this.DEF_NS, "NavigationPropertyBinding"))) {
                String path = event.asStartElement().getAttributeByName(new QName("Path")).getValue();
                String target = event.asStartElement().getAttributeByName(new QName("Target")).getValue();
                entitySet.addBinding(path, target);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(start.getName())) continue;
            completed = true;
        }
        return entitySet;
    }
}

